<?php

/**
 * i-doit
 *
 * Model: Data-holder for the exporters.
 *
 * @package     i-doit
 * @subpackage  Modules
 * @author      Selcuk Kekec <skekec@i-doit.com>
 * @version     1.0.0
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       i-doit 1.4.0
 */
class isys_document_export_model
{
	/**
	 * Text as html.
	 * @var  string
	 */
	protected $m_text = null;

	/**
	 * Chapter level.
	 * @var  integer
	 */
	protected $m_level = null;

	/**
	 * Chapter position string.
	 * @var  string
	 */
	protected $m_pos = null;

	/**
	 * Chapter title.
	 * @var  string
	 */
	protected $m_title = null;

	/**
	 * Chapter on new page or not
	 * @var integer
	 */
	protected $m_new_page = null;


	/**
	 * Get value if chapter shall be created on the new page or not
	 *
	 * @return int
	 */
	public function get_new_page()
	{
		return $this->m_new_page;
	}


	/**
	 * Sets if chapter shall be created on the new page or not
	 *
	 * @param $p_value
	 * @return $this
	 */
	public function set_new_page($p_value)
	{
		$this->m_new_page = $p_value;
		return $this;
	}

    /**
     * @return isys_document_export_model
     */
    public static function factory()
    {
        return new self();
    }


	/**
	 * Constructor.
	 */
	public function __construct ()
	{
		;
	} // function


	/**
	 * Get text.
	 *
	 * @return  string
	 */
	public function get_text ()
	{
		return $this->m_text;
	} // function


	/**
	 * Set raw html text.
	 *
	 * @param   string  $p_text  HTML
	 * @return  isys_document_export_model
	 */
	public function set_text ($p_text)
	{
		$this->m_text = $p_text;

		return $this;
	} // function


	/**
	 * Get level.
	 *
	 * @return  integer
	 */
	public function get_level ()
	{
		return $this->m_level;
	} // function


	/**
	 * Set level.
	 *
	 * @param   integer  $p_level
	 * @return  isys_document_export_model
	 */
	public function set_level ($p_level)
	{
		$this->m_level = $p_level;

		return $this;
	} // function


	/**
	 * Get position of model.
	 *
	 * @return  string
	 */
	public function get_pos ()
	{
		return $this->m_pos;
	} // function


	/**
	 * Set positon string.
	 *
	 * @param   string  $p_pos
	 * @return  isys_document_export_model
	 */
	public function set_pos ($p_pos)
	{
		$this->m_pos = $p_pos;

		return $this;
	} // function


	/**
	 * Get title.
	 *
	 * @return  string
	 */
	public function get_title ()
	{
		return $this->m_title;
	} // function


	/**
	 * Set title.
	 *
	 * @param   string  $p_title
	 * @return  isys_document_export_model
	 */
	public function set_title ($p_title)
	{
		$this->m_title = $p_title;

		return $this;
	} // function
} // class