<?php

use idoit\Module\Floorplan\Model\Floorplan;

/**
 * i-doit
 * Popup class for creating floorplan placeholder
 *
 * @package     i-doit
 * @subpackage  Popups
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @version     1.0
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_popup_document_placeholder_floorplan extends isys_component_popup
{
    /**
     * Handle request.
     *
     * @param  isys_module_request $moduleRequest
     *
     * @return void
     */
    public function &handle_module_request(isys_module_request $moduleRequest)
    {
        $error = '';
        $floorplans = [];
        $featureAvailable = false;
        $floorplanWithoutImage = false;

        try {
            if (class_exists(Floorplan::class)) {
                $floorplanModel = Floorplan::instance($this->database);

                if (method_exists($floorplanModel, 'getFloorplanWithSnapshot')) {
                    $featureAvailable = true;
                    $floorplanResult = Floorplan::instance($this->database)->getFloorplanWithSnapshot();

                    while ($row = $floorplanResult->get_row()) {
                        $floorplans[] = [
                            'objectId' => $row['objectId'],
                            'objectTitle' => $row['objectTitle'],
                            'snapshot' => $row['snapshot'],
                        ];

                        if (empty($row['snapshot'])) {
                            $floorplanWithoutImage = true;
                        }
                    }
                }
            }
        } catch (Exception $e) {
            $error = $e->getMessage();
        }

        $this->template
            ->assign('error', $error)
            ->assign('floorplans', $floorplans)
            ->assign('floorplanUrl', isys_application::instance()->www_path . 'floorplan/visualization/')
            ->assign('featureAvailable', $featureAvailable)
            ->assign('floorplanWithoutImage', $floorplanWithoutImage)
            ->display(isys_module_document::getPath() . 'templates/popup/placeholder_floorplan.tpl');

        die();
    }
}
