<?php

namespace idoit\Module\Document\Controller;

use idoit\Module\Document\CustomFields\Model\Configuration;
use idoit\Module\Document\CustomFields\Repository\CustomFieldsRepository;
use isys_application as Application;
use isys_document_dao_templates;
use isys_format_json as JSON;
use isys_register as Register;

/**
 * i-doit cmdb controller
 *
 * @package   Modules
 * @copyright synetics GmbH
 * @license   http://www.i-doit.com/license
 */
class Ajax extends Main
{
    /**
     * @var array
     */
    protected $response;

    /**
     * Overwriting the "handle" method.
     *
     * @param Register    $request
     * @param Application $application
     *
     * @return  null
     */
    public function handle(Register $request, Application $application)
    {
        return null;
    }

    /**
     * Pre method gets called by the framework.
     */
    public function pre()
    {
        header('Content-Type: application/json');

        $this->response = [
            'success' => true,
            'data'    => null,
            'message' => null
        ];
    }

    /**
     * @param Register $request
     *
     * @throws \Exception
     */
    public function loadTemplateFields(Register $request)
    {
        $templateId = (int)$request->get('POST')->get('templateId');

        $customFieldData = [];

        if ($templateId > 0) {
            $customFieldRepository = new CustomFieldsRepository();
            $customFields = $customFieldRepository->getCustomFieldsForTemplate($templateId);

            foreach ($customFields as $customField) {
                $customFieldValue = $customField->getValue();
                $customFieldStringValue = $customField->getValue()->getStringValue() ?: $customField->getDefaultValue()->getStringValue();

                $customFieldData[$customField->getName()] = $customFieldValue->getTemplate(
                    'custom-field[' . $customField->getId() . ']',
                    $customFieldStringValue,
                    true
                );
            }
        }

        $this->response['data'] = $customFieldData;
    }

    /**
     * Post method gets called by the framework.
     */
    public function post()
    {
        echo JSON::encode($this->response);
        die;
    }
}
