"use strict";

var $chapter_creation = $('chapter_creation'),
    $template_export = $('navbar_item_template_export'),
    $display_toc = $('general.toc'),
    $display_headlines = $('general.headlines'),
    $options_container = $('tab3'),
    $font_upload = $('font-upload'),
    $font_upload_result = $('font-upload-result'),
    $backgroundImageUpload = $$('.background-image-upload');

/**
 * Show chapter if template is saved
 */
if ($('template_id') && !$F('template_id').blank()) {
	$$('.chapterCreation').invoke('show');
}

/**
 * Edit | Remove | Add chapter buttons
 */
if ($chapter_creation) {
	$chapter_creation.on('click', 'a.chapterEditor', function (event, element) {
		window.location.href = '?[{$smarty.const.C__GET__MODULE_ID}]=[{$smarty.const.C__MODULE__DOCUMENT}]' +
			'&pID=chapters&id=' + element.up(2).getAttribute('data-chapter-id') + '&action=edit&[{$smarty.const.C__DOCUMENT__GET__DOCUMENT_ID}]=' + $F('template_id');
	});

	$chapter_creation.on('click', 'a.chapterRemover', function (event, $el) {
        if (!confirm('[{isys type="lang" ident="LC__MODULE__DOCUMENT__POPUP__REMOVE__TEXT" p_bHtmlEncode=false}]')) {
            return;
        }
    
        new Ajax.Request('?[{$smarty.const.C__GET__MODULE_ID}]=[{$smarty.const.C__MODULE__DOCUMENT}]&ajax=1&call=document&method=removeChapter', {
            method: 'post',
            parameters: {
                chapterID: $el.up('[data-chapter-id]').getAttribute('data-chapter-id')
            },
            onSuccess: function (transport) {
                var l_response = transport.responseText;
                
                if (l_response == 1) {
                    location.reload();
                }
            }
        });
	});

	$chapter_creation.on('click', 'button.addChapter', function (event, element) {
		var l_chapterID = '',
			documentType = $F('C__DOCUMENT__TYPE');

		if (element.up(2).hasAttribute('data-chapter-id')) {
			l_chapterID = element.up(2).getAttribute('data-chapter-id');
		}

		window.location.href = '?[{$smarty.const.C__GET__MODULE_ID}]=[{$smarty.const.C__MODULE__DOCUMENT}]' +
            '&[{$smarty.const.C__GET__SETTINGS_PAGE}]=document_templates' +
            '&pID=chapters&parentChapterID=' + l_chapterID +
            '&documentTypeID=' + documentType +
            '&action=edit' +
            '&[{$smarty.const.C__DOCUMENT__GET__DOCUMENT_ID}]=' + $F('template_id') +
            '&[{$smarty.const.C__GET__TREE_NODE}]=[{$smarty.const.C__MODULE__DOCUMENT}]0000' + $F('template_id');
	});

}

if ($('documentTabs')) {
	new Tabs('documentTabs', {
		wrapperClass: 'browser-tabs',
		contentClass: 'browser-tab-content',
		tabClass: 'text-shadow mouse-pointer'
	});
}

if ($template_export) {
	$template_export.writeAttribute('onclick', null).on('click', function () {
		$template_export.addClassName('opacity-30')
			.down('img').writeAttribute('src', '[{$dir_images}]ajax-loading.gif')
			.next('span').update('[{isys type="lang" ident="LC__UNIVERSAL__LOADING"}]');

		new Ajax.Request('?call=document&method=export_template&ajax=1', {
			method: 'post',
			parameters: {
				id: $F('template_id')
			},
			onSuccess: function (transport) {
				var json = transport.responseJSON;

				is_json_response(transport, true);

				$template_export.removeClassName('opacity-30')
					.down('img').writeAttribute('src', '[{$dir_images}]icons/silk/database_copy.png')
					.next('span').update('[{isys type="lang" ident="LC__MODULE__DOCUMENT__DOCUMENT_TEMPLATE__TEMPLATE_EXPORT_BUTTON"}]');

				if (json.success) {
					idoit.Notify.success('[{isys type="lang" ident="LC__MODULE__DOCUMENT__DOCUMENT_TEMPLATE__TEMPLATE_EXPORT_FINISHED"}]');

					// Once finished, prepare the download.
					document.location.href = json.data.download_url;
				} else {
					idoit.Notify.error(json.message, {sticky: true});
				}
			}
		});
	});
}

if ($display_toc && $display_headlines) {
	$display_toc.on('change', function () {
		if ($display_toc.getValue() > 0) {
			$display_headlines.disable().setValue(1);
		} else {
			$display_headlines.enable();
		}
	});

	$display_headlines.on('change', function () {
		var $colorpicker = $options_container.select('input.jscolor');

		if ($display_headlines.getValue() > 0) {
			$colorpicker.invoke('enable');
		} else {
			$colorpicker.invoke('disable');
		}
	});

	$display_toc.simulate('change');
	$display_headlines.simulate('change');
}

if ($font_upload) {
	[{if $upload_dir_writable}]
	new qq.FileUploader({
		element: $font_upload,
		action: '[{$ajaxFontUploadUrl}]',
		multiple: false,
		autoUpload: true,
		sizeLimit: 52428800, // About 50 MB.
		allowedExtensions: ['ttf'],
		onUpload:function(id){
			$font_upload_result
				.show()
				.insert(new Element('div', {id:'font-upload-result-' + id, className:'mb5'})
					.update(new Element('img', {src:'[{$dir_images}]ajax-loading.gif', className:'vam mr5'}))
					.insert(new Element('span').update('[{isys type="lang" ident="LC__UNIVERSAL__LOADING"}]')))
		},
		onComplete: function (id, filename, response) {
			var $result = $('font-upload-result-' + id);

			if ($result) {
				if (response.success && response.data.success) {
					$result
						.addClassName('box-green')
						.update('[{isys type="lang" ident="LC__MODULE__DOCUMENT__DOCUMENT_TEMPLATE__UPLOAD_TTF_SUCCESS"}]: "' + (response.data.fontname || filename) + '"');
				} else {
					$result
						.addClassName('box-red')
						.update(response.message || '[{isys type="lang" ident="LC__MODULE__DOCUMENT__DOCUMENT_TEMPLATE__UPLOAD_TTF_FAILURE"}]');
				}
			}
		},
		onError: function (id, filename, response) {
			var $result = $('font-upload-result-' + id);

			if ($result) {
				$result
					.addClassName('box-red')
					.update(response.message || '[{isys type="lang" ident="LC__MODULE__DOCUMENT__DOCUMENT_TEMPLATE__UPLOAD_TTF_FAILURE"}]');
			}
		},
		dragText: '[{isys type="lang" ident="LC_FILEBROWSER__DROP_FILE"}]',
		multipleFileDropNotAllowedMessage: '[{isys type="lang" ident="LC_FILEBROWSER__SINGLE_FILE_UPLOAD" p_bHtmlEncode=false}]',
		uploadButtonText: '<img src="[{$dir_images}]icons/silk/zoom.png" alt="" class="vam mr5" style="margin-top:-1px; height:16px;" /><span style="vertical-align:baseline;">[{isys type="lang" ident="LC__UNIVERSAL__FILE_ADD"}]</span>',
		cancelButtonText: '&nbsp;',
		failUploadText: '[{isys type="lang" ident="LC__UNIVERSAL__ERROR"}]'
	});
	[{else}]
	$font_upload
		.update(new Element('button', {type:'button', disabled:true, className:'btn'})
			.update(new Element('img', {src:'[{$dir_images}]icons/silk/zoom.png', className:'mr5'}))
			.insert(new Element('span').update('[{isys type="lang" ident="LC__UNIVERSAL__FILE_ADD"}]')));
	[{/if}]
}

$backgroundImageUpload.each(function($uploadContainer) {
    var $removeButton = $uploadContainer.next('.result').down('button');

    new qq.FileUploader({
        element: $uploadContainer,
        action: '[{$ajaxBackgroundUploadUrl}]',
        multiple: false,
        autoUpload: true,
        sizeLimit: 1048576, // About 1 MB.
        allowedExtensions: ['jpg', 'jpeg', 'png', 'gif'],
        params:{type:$uploadContainer.readAttribute('data-type')},
        onComplete: function (id, filename, response) {
            if (!response.success || !response.data.success) {
                idoit.Notify.error(response.message || '[{isys type="lang" ident="LC__MODULE__DOCUMENT__DOCUMENT_TEMPLATE__UPLOAD_BACKGROUND_FAILURE"}]', {life:5});
                return;
            }
    
            idoit.Notify.success('[{isys type="lang" ident="LC__MODULE__DOCUMENT__DOCUMENT_TEMPLATE__UPLOAD_BACKGROUND_SUCCESS"}]', {life:5})
            $uploadContainer.next('input').setValue(response.data.filename);
            $uploadContainer.next('.result')
                .removeClassName('hide')
                .removeClassName('text-red')
                .addClassName('text-green')
                .update(new Element('img', {src: window.dir_images + 'icons/silk/tick.png', className:'vam mr5'}))
                .insert('[{isys type="lang" ident="LC__MODULE__DOCUMENT__DOCUMENT_TEMPLATE__UPLOAD_BACKGROUND_SUCCESS_AFTER_SAVE"}]');
        },
        onError: function (id, filename, response) {
            idoit.Notify.error(response.message || '[{isys type="lang" ident="LC__MODULE__DOCUMENT__DOCUMENT_TEMPLATE__UPLOAD_BACKGROUND_FAILURE"}]', {life:5});
    
            $uploadContainer.next('.result')
                .removeClassName('hide')
                .removeClassName('text-green')
                .addClassName('text-red')
                .update(new Element('img', {src: window.dir_images + 'icons/silk/tick.png', className:'vam mr5'}))
                .insert('[{isys type="lang" ident="LC__MODULE__DOCUMENT__DOCUMENT_TEMPLATE__UPLOAD_BACKGROUND_FAILURE"}]');
        },
        dragText: '[{isys type="lang" ident="LC_FILEBROWSER__DROP_FILE"}]',
        multipleFileDropNotAllowedMessage: '[{isys type="lang" ident="LC_FILEBROWSER__SINGLE_FILE_UPLOAD" p_bHtmlEncode=false}]',
        uploadButtonText: '<img src="[{$dir_images}]icons/silk/zoom.png" alt="" class="vam mr5" style="margin-top:-1px; height:16px;" /><span style="vertical-align:baseline;">[{isys type="lang" ident="LC__UNIVERSAL__FILE_ADD"}]</span>',
        cancelButtonText: '&nbsp;',
        failUploadText: '[{isys type="lang" ident="LC__UNIVERSAL__ERROR"}]'
    });
    
    if ($removeButton) {
        $removeButton.on('click', function () {
            $removeButton.up('.result')
                .update(new Element('img', {src: window.dir_images + 'icons/silk/tick.png', className:'vam mr5'}))
                .insert('[{isys type="lang" ident="LC__MODULE__DOCUMENT__DOCUMENT_TEMPLATE__UPLOAD_BACKGROUND_SUCCESS_AFTER_SAVE"}]')
                .previous('input')
                .setValue('');
        });
    }
});
