<?php

/**
 * i-doit Placeholder Image
 *
 * @package     Modules
 * @subpackage  Document
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_document_compiler_placeholder_image extends isys_document_compiler_placeholder
{
    /**
     * Compiler.
     *
     * @return  string
     */
    protected function get()
    {
        global $g_dirs;

        $l_images = [];

        if ($this->m_data['data']['image_id'] > 0) {
            $l_res = (new isys_cmdb_dao_category_g_images($this->m_dao_property->get_database_component()))
                ->get_data($this->m_data['data']['image_id']);
        } else {
            $l_res = (new isys_cmdb_dao_category_g_images($this->m_dao_property->get_database_component()))
                ->get_certain_images_by_object($this->get_compiler()
                ->get_master_object(), strstr($this->m_data['data']['image_option'], '-', true));
        }

        if (count($l_res)) {
            // Select the last revision ID and add one for our filepath.
            $l_revision = 1 +
                $this->m_dao_property->retrieve('SELECT isys_document_revision__id FROM isys_document_revision ORDER BY isys_document_revision__id DESC LIMIT 1;')
                    ->get_row_value('isys_document_revision__id');

            while ($l_row = $l_res->get_row()) {
                // We use a MD5 hash so that the same image will not create endless copies of itself.
                $l_image_path = isys_module_document::get_temp_dir() . DS . substr(md5($this->m_data['data']['image_id'] . $l_row['isys_catg_images_list__filename']), 0, 8) .
                    '_rev' . $l_revision . '_' . isys_helper_upload::prepare_filename($l_row['isys_catg_images_list__filename']);

                if (!file_exists($l_image_path)) {
                    if (!is_dir(dirname($l_image_path))) {
                        if (!mkdir(dirname($l_image_path), 0777, true)) {
                            isys_notify::error(_L('LC__MODULE__DOCUMENT__DOCUMENT_CREATION__RESOURCE_DIR_COULD_NOT_BE_CREATED', dirname($l_image_path)), ['sticky' => true]);
                        }
                    }

                    if (is_writable(dirname($l_image_path))) {
                        if (!file_put_contents($l_image_path, base64_decode($l_row['isys_catg_images_list__filecontent']))) {
                            isys_notify::error(_L('LC__MODULE__DOCUMENT__DOCUMENT_CREATION__RESOURCE_FILE_COULD_NOT_BE_CREATED', $l_image_path), ['sticky' => true]);
                        }
                    } else {
                        isys_notify::error(_L('LC__MODULE__DOCUMENT__DOCUMENT_CREATION__RESOURCE_DIR_NOT_WRITABLE', dirname($l_image_path)), ['sticky' => true]);
                    }
                }

                if (file_exists($l_image_path)) {
                    $l_image_path = str_replace('\\', '/', $g_dirs['www_dir'] . str_replace(BASE_DIR, '', $l_image_path));

                    $l_images[] = '<img src="' . $l_image_path . '" style="display:block;" />';
                } else {
                    $l_images[] = '<em>' . _L('LC__MODULE__DOCUMENT__DOCUMENT_CREATION__RESOURCE_IMAGE_COULD_NOT_BE_FOUND', $l_image_path) . '</em>';
                }
            }
        }

        return implode('<br />', $l_images);
    }

    /**
     * Not needed.
     */
    protected function post()
    {
    }

    /**
     * Not needed.
     */
    protected function pre()
    {
    }
}
