<?php
/**
 * i-doit
 *
 * Class autoloader.
 *
 * @package     i-doit
 * @subpackage  Modules
 * @author      Selcuk Kekec <skekec@i-doit.com>
 * @version     1.0
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */

class isys_module_document_autoload extends isys_module_manager_autoload
{
    /**
     * Module specific autoloader.
     *
     * @param   string $className
     *
     * @return  boolean
     * @throws  Exception
     */
    public static function init($className)
    {
        $addOnPath = '/src/classes/modules/document/';
        $classMap = [
            'isys_ajax_handler_document' => 'handler/ajax/isys_ajax_handler_document.class.php',
            'isys_api_model_document' => 'api/isys_api_model_document.class.php',
            'isys_api_model_document_documents' => 'api/isys_api_model_document_documents.class.php',
            'isys_auth_document' => 'auth/isys_auth_document.class.php',
            'isys_cmdb_dao_category_g_document' => 'cmdb/dao/global/isys_cmdb_dao_category_g_document.class.php',
            'isys_cmdb_dao_list_catg_document' => 'cmdb/dao/list/isys_cmdb_dao_list_catg_document.class.php',
            'isys_cmdb_ui_category_g_document' => 'cmdb/ui/global/isys_cmdb_ui_category_g_document.class.php',
            'isys_dashboard_widgets_document_last_revisions' => 'dashboard/widgets/last_revisions/isys_dashboard_widgets_document_last_revisions.class.php',
            'isys_document_compiler' => 'compiler/isys_document_compiler.class.php',
            'isys_document_compiler_chapter' => 'compiler/isys_document_compiler_chapter.class.php',
            'isys_document_compiler_document' => 'compiler/isys_document_compiler_document.class.php',
            'isys_document_compiler_model' => 'compiler/model/isys_document_compiler_model.class.php',
            'isys_document_compiler_model_chapter' => 'compiler/model/isys_document_compiler_model_chapter.class.php',
            'isys_document_compiler_model_document' => 'compiler/model/isys_document_compiler_model_document.class.php',
            'isys_document_compiler_placeholder' => 'compiler/placeholder/isys_document_compiler_placeholder.class.php',
            'isys_document_compiler_placeholder_category' => 'compiler/placeholder/isys_document_compiler_placeholder_category.class.php',
            'isys_document_compiler_placeholder_image' => 'compiler/placeholder/isys_document_compiler_placeholder_image.class.php',
            'isys_document_compiler_placeholder_property' => 'compiler/placeholder/isys_document_compiler_placeholder_property.class.php',
            'isys_document_compiler_placeholder_report' => 'compiler/placeholder/isys_document_compiler_placeholder_report.class.php',
            'isys_document_compiler_placeholder_template_var' => 'compiler/placeholder/isys_document_compiler_placeholder_template_var.class.php',
            'isys_document_dao' => 'dao/isys_document_dao.class.php',
            'isys_document_dao_chapters' => 'dao/isys_document_dao_chapters.class.php',
            'isys_document_dao_components' => 'dao/isys_document_dao_components.class.php',
            'isys_document_dao_revision' => 'dao/isys_document_dao_revision.class.php',
            'isys_document_dao_templates' => 'dao/isys_document_dao_templates.class.php',
            'isys_document_export' => 'export/isys_document_export.class.php',
            'isys_document_export_html' => 'export/isys_document_export_html.class.php',
            'isys_document_export_model' => 'export/isys_document_export_model.class.php',
            'isys_document_export_pdf' => 'export/isys_document_export_pdf.class.php',
            'isys_document_export_template_json' => 'export/isys_document_export_template_json.class.php',
            'isys_document_formattable' => 'format/isys_document_formattable.class.php',
            'isys_document_format_html' => 'format/isys_document_format_html.class.php',
            'isys_document_format_text' => 'format/isys_document_format_text.class.php',
            'isys_document_format_pdf' => 'format/isys_document_format_pdf.class.php',
            'isys_document_view_online_repository' => 'views/isys_document_view_online_repository.class.php',
            'isys_handler_document' => 'handler/controller/isys_handler_document.class.php',
            'isys_popup_document_create_document' => 'popups/isys_popup_document_create_document.class.php',
            'isys_popup_document_placeholder_external_object' => 'popups/isys_popup_document_placeholder_external_object.class.php',
            'isys_popup_document_placeholder_images' => 'popups/isys_popup_document_placeholder_images.class.php',
            'isys_popup_document_placeholder_object' => 'popups/isys_popup_document_placeholder_object.class.php',
            'isys_popup_document_placeholder_report' => 'popups/isys_popup_document_placeholder_report.class.php',
            'isys_popup_document_placeholder_template_vars' => 'popups/isys_popup_document_placeholder_template_vars.class.php',
            'isys_popup_document_revision_comment' => 'popups/isys_popup_document_revision_comment.class.php',
            'isys_popup_document_template_duplicate' => 'popups/isys_popup_document_template_duplicate.class.php',
            'isys_popup_document_template_import' => 'popups/isys_popup_document_template_import.class.php',
        ];

        if (isset($classMap[$className]) && parent::include_file($addOnPath . $classMap[$className])) {
            isys_cache::keyvalue()->ns('autoload')->set($className, $addOnPath . $classMap[$className]);

            return true;
        }

        return false;
    }
}
