<?php

/**
 * i-doit
 *
 * Popup class for creating placeholder for external objects
 *
 * @package     i-doit
 * @subpackage  Popups
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @version     1.0
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_popup_document_placeholder_external_object extends isys_component_popup
{
    /**
     * Handle request.
     *
     * @param  isys_module_request $moduleRequest
     *
     * @return isys_component_template|void
     * @throws \idoit\Exception\JsonException
     * @throws isys_exception_database
     */
    public function &handle_module_request(isys_module_request $moduleRequest)
    {
        $l_preselection = [
            'root' => null,
            'lvls' => null
        ];

        if (isset($_POST['data']) && isys_format_json::is_json_array($_POST['data'])) {
            $l_preselection = isys_popup_document_placeholder_object::handle_preselection(isys_format_json::decode($_POST['data']));
        }

        // Define some rules for our property selector.
        $rules = [
            'document_popup_property_selector' => [
                'grouping'          => false,
                'sortable'          => true,
                'p_bInfoIconSpacer' => 0,
                'provide'           => C__PROPERTY__PROVIDES__REPORT,
                'p_consider_rights' => true,
                'custom_fields'     => true,
                'report'            => true,
                'dialog_width'      => '280px',
                'preselection'      => $l_preselection['root'],
                'preselection_lvls' => $l_preselection['lvls']
            ],
            'document-popup-report-header-background' => [
                'p_strClass' => 'jscolor input-mini',
                'p_strValue' => 'ffffff'
            ],
            'document-popup-report-header-textcolor' => [
                'p_strClass' => 'jscolor input-mini',
                'p_strValue' => '000000'
            ],
            'document-popup-report-show-grid'  => [
                'p_arData'        => [
                    0            => $this->language->get('LC__MODULE__DOCUMENT__PLACEHOLDER__REPORT__DISPLAY_GRID__NONE'),
                    'horizontal' => $this->language->get('LC__MODULE__DOCUMENT__PLACEHOLDER__REPORT__DISPLAY_GRID__HORIZONTAL'),
                    'vertical'   => $this->language->get('LC__MODULE__DOCUMENT__PLACEHOLDER__REPORT__DISPLAY_GRID__VERTICAL'),
                    'all'        => $this->language->get('LC__MODULE__DOCUMENT__PLACEHOLDER__REPORT__DISPLAY_GRID__ALL')
                ],
                'p_bSort'         => false,
                'p_strSelectedID' => 'all',
                'p_bDbFieldNN'    => true,
                'p_strClass'      => 'input-mini'
            ],
            'document-popup-report-zebra-grid' => [
                'p_strClass' => 'jscolor input-mini',
                'p_strValue' => 'ffffff'
            ],
            'document-popup-report-show-after-page-break' => [
                'p_arData' => [
                    1 => $this->language->get('LC__MODULE__DOCUMENT__PLACEHOLDER__REPORT__DISPLAY_AFTER_PAGE_BREAK__YES'),
                    0 => $this->language->get('LC__MODULE__DOCUMENT__PLACEHOLDER__REPORT__DISPLAY_AFTER_PAGE_BREAK__NO')
                ],
                'p_bSort' => false,
                'p_strSelectedID' => 1,
                'p_bDbFieldNN' => true,
                'p_strClass' => 'input-small'
            ],
            'conditional_message_empty_ext' => [
                'p_strClass' => 'input-small',
            ],
            'conditional_message_full_top_ext' => [
                'p_strClass' => 'input-small',
            ],
            'conditional_message_full_bottom_ext' => [
                'p_strClass' => 'input-small',
            ],
        ];

        $this->template
            ->activate_editmode()
            ->assign('multiValueCategories', $this->getMultiValueCategories())
            ->smarty_tom_add_rules('tom.popup.placeholder', $rules)
            ->display(isys_module_document::getPath() . 'templates/popup/placeholder_externalobject.tpl');

        die();
    }

    /**
     * @return array
     * @throws isys_exception_database
     */
    private function getMultiValueCategories()
    {
        $dao = isys_cmdb_dao::instance($this->database);
        $multiValueCategories = [];

        $result = $dao->retrieve('SELECT isysgui_catg__const AS const FROM isysgui_catg WHERE isysgui_catg__list_multi_value = 1;');

        while ($row = $result->get_row()) {
            $multiValueCategories[] = $row['const'];
        }

        $result = $dao->retrieve('SELECT isysgui_cats__const AS const FROM isysgui_cats WHERE isysgui_cats__list_multi_value = 1;');

        while ($row = $result->get_row()) {
            $multiValueCategories[] = $row['const'];
        }

        $result = $dao->retrieve('SELECT isysgui_catg_custom__const AS const FROM isysgui_catg_custom WHERE isysgui_catg_custom__list_multi_value = 1;');

        while ($row = $result->get_row()) {
            $multiValueCategories[] = $row['const'];
        }

        return $multiValueCategories;
    }
}
