<?php

/**
 * i-doit
 *
 * Popup class for duplicating
 *
 *
 * @package     i-doit
 * @subpackage  Popups
 * @author      Van Quyen Hoang <qhoang@i-doit.de>
 * @version     1.0
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_popup_document_template_duplicate extends isys_component_popup
{
    /**
     * @param  isys_module_request $p_modreq
     *
     * @throws Exception
     * @throws isys_exception_database
     */
    public function &handle_module_request(isys_module_request $p_modreq)
    {
        $documentTypeId = (int)$_GET['documentTypeID'];
        $documentTemplateIds = (isset($_GET['documentTemplateID']) ? isys_format_json::decode($_GET['documentTemplateID']) : null);

        $rules = [
            'C__POPUP__DUPLICATE__DOCUMENT_TEMPLATE__NEW_NAME' => [
                'p_strClass' => 'input-small',
                'p_strValue' => ''
            ],
            'C__POPUP__DUPLICATE__DOCUMENT_TEMPLATE__CATEGORY' => [
                'p_bDbFieldNN'    => 1,
                'p_strClass'      => 'input-small',
                'p_strTable'      => 'isys_document_type',
                'p_strSelectedID' => $documentTypeId
            ]
        ];

        if (is_array($documentTemplateIds)) {
            $documentTemplateIds = array_filter(array_map('intval', $documentTemplateIds));

            if (count($documentTemplateIds) === 1) {
                $templateId = current($documentTemplateIds);

                $rules['C__POPUP__DUPLICATE__DOCUMENT_TEMPLATE__NEW_NAME']['p_strValue'] = isys_document_dao_templates::instance($this->database)
                    ->get_data($templateId)
                    ->get_row_value('isys_document_template__title');
            }
        }

        $this->template
            ->activate_editmode()
            ->assign('documentTemplateID', isys_format_json::encode($documentTemplateIds))
            ->smarty_tom_add_rules('tom.popup.document.duplicate', $rules)
            ->display(isys_module_document::getPath() . 'templates/popup/template_duplicate.tpl');

        die();
    }
}
