<?php

namespace idoit\Module\Document\CustomFields\Repository;

use idoit\Module\Document\CustomFields\Entity\CustomField;
use idoit\Module\Document\CustomFields\Model\Configuration;
use idoit\Module\Document\CustomFields\Model\Document;
use idoit\Module\Document\CustomFields\Value\AbstractCustomFieldValue;
use RecursiveDirectoryIterator;
use RecursiveIteratorIterator;
use SplFileInfo;

class CustomFieldsRepository
{
    /**
     * Returns custom field values for given document
     *
     * @param integer $documentId
     *
     * @return CustomField[]
     */
    public function getCustomFieldsForDocument($documentId)
    {
        $values = [];
        $customFieldResult = (new Document(\isys_application::instance()->container->get('database')))->getByDocumentId($documentId);

        while ($customFieldRow = $customFieldResult->get_row()) {
            $values[] = new CustomField(
                $customFieldRow['customFieldId'],
                $customFieldRow['templateId'],
                $customFieldRow['name'],
                $customFieldRow['dataType'],
                $customFieldRow['defaultValue'] ?: null,
                $customFieldRow['fieldValue'] ?: null
            );
        }

        return $values;
    }

    /**
     * Returns available custom fields for given document template
     *
     * @param integer $templateId
     *
     * @return CustomField[]
     */
    public function getCustomFieldsForTemplate($templateId)
    {
        $values = [];
        $customFieldResult = (new Configuration(\isys_application::instance()->container->get('database')))->getByDocumentTemplateId($templateId);

        while ($customFieldRow = $customFieldResult->get_row()) {
            $values[] = new CustomField(
                $customFieldRow['id'],
                $templateId,
                $customFieldRow['name'],
                $customFieldRow['dataType'],
                $customFieldRow['defaultValue'] ?: null,
                $customFieldRow['fieldValue'] ?: null
            );
        }

        return $values;
    }

    /**
     * Retrieves implemented value type class names, implementing AbstractCustomFieldValue
     *
     * @return AbstractCustomFieldValue[]
     */
    public static function getAvailableValueTypes()
    {
        $customFieldValueDirectory = \isys_module_document::getPath() . 'src/CustomFields/Value/';

        $iterator = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($customFieldValueDirectory, RecursiveDirectoryIterator::SKIP_DOTS));

        $valueTypes = [];

        foreach ($iterator as $file) {
            /** @var $file SplFileInfo */
            // Exclude dot, abstract classes, and interfaces
            if ($file->isDir() || stripos($file->getBasename(), 'abstract') !== false || stripos($file->getBasename(), 'interface') !== false) {
                continue;
            }

            $class = 'idoit\\Module\\Document\\CustomFields\\Value\\' . $file->getBasename('.php');

            if (class_exists($class) && is_subclass_of($class, AbstractCustomFieldValue::class)) {
                $valueTypes[constant($class . '::LABEL')] = new $class(null);
            }
        }

        return $valueTypes;
    }
}
