<?php

namespace idoit\Module\Document\CustomFields\Value;

/**
 * i-doit abstract customfield value.
 *
 * @package     document
 * @author      Kevin Mauel <kmauel@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       1.3.0
 */
abstract class AbstractCustomFieldValue
{
    const LABEL = '';

    /**
     * @var mixed
     */
    protected $value;

    /**
     * AbstractCustomFieldValue constructor.
     *
     * @param mixed $value
     */
    public function __construct($value)
    {
        $this->value = $value;
    }

    /**
     * Retrieves a string representation of the value.
     *
     * @return string
     */
    abstract public function getStringValue();

    /**
     * Retrieves a formatted string representation of the value, ready for the document.
     *
     * @return string
     */
    abstract public function getFormattedValue();

    /**
     * Returns smarty template for value implementation
     *
     * @param  string  $name
     * @param  mixed   $value
     * @param  boolean $editMode
     *
     * @return string
     * @throws \Exception
     */
    abstract public function getTemplate($name, $value, $editMode);
}
