<?php

use idoit\Module\Document\Compiler\Table\Config;
use idoit\Module\Document\Compiler\Table\Table;

/**
 * i-doit Placeholder CategoryEntries
 *
 * @package    Modules
 * @subpackage Document
 * @author     Selcuk Kekec <skekec@synetics.de>
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */
class isys_document_compiler_placeholder_category extends isys_document_compiler_placeholder
{
    /**
     * Category-Data-Result by isys_cmdb_dao::get_cat_by_const.
     *
     * @var array
     */
    protected $m_category_data = null;

    /**
     * DAO of category.
     *
     * @var isys_cmdb_dao_category
     */
    protected $m_category_dao = null;

    /**
     * Properties of category given by get_properties().
     *
     * @var array
     */
    protected $m_category_properties = null;

    /**
     * Dynamic properties of category given by get_dynamic_properties().
     *
     * @var array
     */
    protected $m_dynamic_properties = null;

    /**
     * @var array
     */
    private static $allCategories = [];

    /**
     * Compiler.
     *
     * @return string compiled string
     */
    protected function get()
    {
        $l_compiled_placeholder = "";

        if (!isset($this->m_data[C__CMDB__GET__OBJECT]) && !isset($this->m_data['data'][C__CMDB__GET__OBJECT])) {
            $this->m_data[C__CMDB__GET__OBJECT] = (string)$this->m_compiler->get_master_object();
        } elseif (isset($this->m_data['data'][C__CMDB__GET__OBJECT]) && $this->m_data['data'][C__CMDB__GET__OBJECT] > 0) {
            $this->m_data[C__CMDB__GET__OBJECT] = $this->m_data['data'][C__CMDB__GET__OBJECT];
        } // if

        if ($this->m_data[C__CMDB__GET__OBJECT] && isset($this->m_data['data']['propData'])) {
            $l_compiled_placeholder = $this->getValue($this->m_data[C__CMDB__GET__OBJECT], $this->m_data['data']['propData']);
        } // if

        return $l_compiled_placeholder;
    } // function

    /**
     * Did the property supports lists?
     *
     * @param $p_property array
     *
     * @return bool
     */
    private function provide_list($p_property)
    {
        return (isset($p_property[C__PROPERTY__PROVIDES][C__PROPERTY__PROVIDES__REPORT]) && $p_property[C__PROPERTY__PROVIDES][C__PROPERTY__PROVIDES__REPORT]);
    } // function

    /**
     * Transform category entries to html.
     *
     * @param  integer $objID
     * @param  string  $categoryData
     *
     * @return string Table representation of category entries
     * @throws Exception
     */
    private function getValue($objID, $categoryData)
    {
        $database = isys_application::instance()->container->get('database');
        $language = isys_application::instance()->container->get('language');

        $moduleReport = new isys_module_report_pro();
        $dao = isys_report_dao::instance($database);

        $statusFilter = (array)(!empty($this->m_data['data']['status']) ? $this->m_data['data']['status'] : [C__RECORD_STATUS__NORMAL]);
        $conditionData = [];

        if ($this->m_data['showOnlyPrimaryEntry'] === true) {
            $data = isys_format_json::decode($categoryData);
            $categories = [];

            if (empty(self::$allCategories)) {
                self::$allCategories = isys_cmdb_dao::instance($database)->get_all_categories();
            }

            foreach ($data['root'] as $propertyInfo) {
                if ($propertyInfo['g_custom']) {
                    continue;
                }

                if ($propertyInfo['g'] && defined(key($propertyInfo['g']))) {
                    $categories[] = self::$allCategories[C__CMDB__CATEGORY__TYPE_GLOBAL][constant(key($propertyInfo['g']))];
                    continue;
                }

                if ($propertyInfo['s'] && defined(key($propertyInfo['s']))) {
                    $categories[] = self::$allCategories[C__CMDB__CATEGORY__TYPE_SPECIFIC][constant(key($propertyInfo['s']))];
                }
            }

            $primaryCondition = [];
            $maxCategories = count($categories);

            if (!empty($categories)) {
                foreach ($categories as $category) {
                    $dao = $category['class_name']::instance($database);
                    $categoryProperties = $dao->get_properties();
                    $maxCategories--;

                    if (!isset($categoryProperties['primary'])) {
                        continue;
                    }

                    if ($categoryProperties['primary'][C__PROPERTY__PROVIDES][C__PROPERTY__PROVIDES__REPORT]) {
                        $conditionData[] = [
                            [
                                'category'   => $category['const'],
                                'property'   => $category['const'] . '-primary',
                                'comparison' => '=',
                                'value'      => 1
                            ]
                        ];
                        if ($maxCategories > 1) {
                            $conditionData[] = 'AND';
                        }
                    }
                }
            }
        }

        $reportQuery = isys_cmdb_dao_category_property::instance($database)
            ->reset()
            ->set_query_as_report(true)
            ->setMultivalueStatusFilter($statusFilter)
            ->setSelectedConditions($conditionData)
            ->create_property_query_for_report(null, $categoryData, true, ' AND obj_main.isys_obj__id = ' . $dao->convert_sql_id($objID));

        $result['content'] = $moduleReport->process_show_report($reportQuery, null, true, false, true, false);
        $rawHeader = $moduleReport->get_report_headers();

        if (isset($result['content']) && count($result['content']) > 0) {
            unset($rawHeader['__id__'], $rawHeader['__obj_id__']);

            $header = $rawHeader;

            foreach ($header as $key => $headerValue) {
                if (strpos($headerValue, '->')) {
                    $header[$key] = substr($headerValue, strrpos($headerValue, ' ->') + 3) . ' (' . substr($headerValue, 0, strpos($headerValue, ' ->')) . ')';
                }
            }

            $content = [];
            // If this key is set, we are handling an "old" configuration, so we set the defaults:
            if (isset($this->m_data['data']['optBorder'])) {
                $this->m_data['data']['showGrid'] = 'all';
                $this->m_data['data']['showAfterPageBreak'] = true;
                $this->m_data['data']['headerTextStyle'] = 'b';
                $this->m_data['data']['headerTextAlignment'] = 'left';
            }

            $showTableHeader = (isset($this->m_data['data']['optHeader']) && $this->m_data['data']['optHeader']);

            if (is_array($result['content']) && count($result['content'])) {
                foreach ($result['content'] as $rowData) {
                    $row = [];

                    foreach ($rawHeader as $value) {
                        $value = (strpos($rowData[$value], 'LC__') === 0) ? $language->get($rowData[$value]) : $rowData[$value];

                        $value = str_replace('&nbsp;', ' ', $value);

                        $row[] = $this->normalize($value);
                    }

                    // @see DOKU-403 Skip empty rows!
                    $filledValues = array_filter($row, function ($column) {
                        return trim($column) !== '';
                    });

                    if (count($filledValues) === 0) {
                        continue;
                    }

                    $content[] = $row;
                }
            }

            $config = (new Config())->setGrid($this->m_data['data']['showGrid'])
                ->setShowHeader($showTableHeader)
                ->setShowHeaderAfterPageBreak($this->m_data['data']['showAfterPageBreak'])
                ->setZebraRowColor($this->m_data['data']['zebraGrid']);

            if ($showTableHeader) {
                $config->setHeaderBackgroundColor($this->m_data['data']['headerBackground'])
                    ->setHeaderTextAlign($this->m_data['data']['headerTextAlignment'])
                    ->setHeaderTextColor($this->m_data['data']['headerTextcolor'])
                    ->setHeaderTextStyle($this->m_data['data']['headerTextStyle']);
            }

            if ($this->m_data['data']['isConditionalMessage'] == 1) {
                if ($this->isEmptyTable($content)) {
                    return '<p>' . $this->m_data['data']['conditionalMessageEmpty'] . '</p>';
                } else {
                    return '<p>' . $this->m_data['data']['conditionalMessageFullTop'] . '</p>' .
                        (new Table($header, $content, $config))->compile() .
                        '<p>' . $this->m_data['data']['conditionalMessageFullBottom'] . '</p>';
                }
            } else {
                if (!$this->isEmptyTable($content)) {
                    return (new Table($header, $content, $config))->compile();
                }
            }
        }

        return '';
    }

    /**
     * @param array $content
     * @return bool
     */
    private function isEmptyTable(array $content)
    {
        if (empty($content)) {
            return true;
        } elseif (count($content)===1) {
            foreach ($content[0] as $key => $value) {
                if (trim($value) !== '') {
                    return false;
                }
            }
            return true;
        } else {
            return false;
        }
    }

    /**
     * Returns the result of the callback given by the dynamic property.
     *
     * @param   integer $p_id
     * @param   array   $p_callback
     *
     * @return  mixed
     */
    public function get_dynamic_property($p_id, $p_callback)
    {
        $l_res = $this->m_category_dao->get_data($p_id);

        if (is_array($p_callback) && count($l_res) && isset($p_callback[1])) {
            return call_user_func([$p_callback[0], $p_callback[1]], $l_res->get_row());
        }

        return null;
    }

    /**
     * Not needed
     */
    protected function post()
    {
    }

    /**
     * Object-ID Handling
     */
    protected function pre()
    {
    }
}
