<?php

use idoit\Module\Document\Compiler\Table\Config;
use idoit\Module\Document\Compiler\Table\Table;
use idoit\Module\Report\SqlQuery\Placeholder\ObjectId;
use idoit\Module\Report\SqlQuery\Placeholder\UnequalObjectId;

/**
 * i-doit Placeholder Reports
 *
 * @package     Modules
 * @subpackage  Document
 * @author      Selcuk Kekec <skekec@synetics.de>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_document_compiler_placeholder_report extends isys_document_compiler_placeholder
{
    /**
     * Compiler.
     *
     * @return string
     * @throws Exception
     * @throws isys_exception_general
     */
    protected function get()
    {
        $reportDao = isys_report_dao::instance();
        $language = isys_application::instance()->container->get('language');

        $output = '';
        $content = [];
        $showTableHeader = (isset($this->m_data['data']['optHeader']) && $this->m_data['data']['optHeader']);

        // If this key is set, we are handling an "old" configuration, so we set the defaults:
        if (isset($this->m_data['data']['optBorder'])) {
            $this->m_data['data']['showGrid'] = 'all';
            $this->m_data['data']['showAfterPageBreak'] = true;
            $this->m_data['data']['headerTextStyle'] = 'b';
            $this->m_data['data']['headerTextAlignment'] = 'left';
        }

        // Get report.
        $reportRow = $reportDao->get_reports(null, [$this->m_data['data']['id']], null, true, false)[0];
        $reportQuery = $reportRow['isys_report__query'];

        if ((int)$reportRow['isys_report__category_report'] === 1) {
            // Assuming there is an object-id placeholder, we add the connected object as user-input

            foreach ([ObjectId::getIdentifier(), UnequalObjectId::getIdentifier()] as $identifier) {
                if (stripos($reportQuery, '\'' . $identifier . '\'') === false) {
                    continue;
                }

                $reportQuery = str_replace(
                    '\'' . $identifier . '\'',
                    '\'' . $identifier . ' ' . $this->get_compiler()->get_master_object() . '\'',
                    $reportQuery
                );
            }

            $reportQuery = $reportDao->replacePlaceHolders($reportQuery);
        }

        // Execute report.
        $l_report_res = $reportDao->query($reportQuery, null, true);

        if (!is_array($l_report_res['headers']) || !count($l_report_res['headers'])) {
            return $output;
        }

        // @see DOKU-372 Use the 'reformatResult' helper :)
        $content = isys_report::reformatResult(
            $l_report_res,
            (bool)$reportRow['isys_report__show_html'],
            (bool)$reportRow['isys_report__compressed_multivalue_results']
        );

        // @see DOKU-372 Iterate over the content to clean up some things.
        $content = array_map(function ($row) {
            // Remove the '__id__' field.
            unset($row['__id__']);

            return array_map(function ($column) {
                // Remove any '&nbsp;' at the beginning and end.
                return trim(str_replace('&nbsp;', ' ', $column));
            }, $row);
        }, $content);

        $config = (new Config())->setGrid($this->m_data['data']['showGrid'])
            ->setShowHeader($showTableHeader)
            ->setShowHeaderAfterPageBreak($this->m_data['data']['showAfterPageBreak'])
            ->setZebraRowColor($this->m_data['data']['zebraGrid']);

        if ($showTableHeader) {
            $config->setHeaderBackgroundColor($this->m_data['data']['headerBackground'])
                ->setHeaderTextAlign($this->m_data['data']['headerTextAlignment'])
                ->setHeaderTextColor($this->m_data['data']['headerTextcolor'])
                ->setHeaderTextStyle($this->m_data['data']['headerTextStyle']);
        }

        if (isset($this->m_data['data']['showTitle']) && $this->m_data['data']['showTitle']) {
            $output .= '<p><strong>' . $reportRow['isys_report__title'] . '</strong></p>';
        }

        if (isset($this->m_data['data']['showDescription']) && $this->m_data['data']['showDescription'] === 'above') {
            $output .= $this->prepareDescription($reportRow['isys_report__description']);
        }

        $output .= (new Table($l_report_res['headers'], $content, $config))->compileXML();

        if (isset($this->m_data['data']['showDescription']) && $this->m_data['data']['showDescription'] === 'below') {
            $output .= $this->prepareDescription($reportRow['isys_report__description']);
        }

        return $output;
    }

    /**
     * Format the description to paragraphs.
     *
     * @param  string $str
     *
     * @return string
     */
    private function prepareDescription($str)
    {
        // Unify line endings.
        $str = str_replace(["\r\n", "\r"], "\n", $str);
        ;

        // Wrap the string in a paragraph.
        $str = '<p>' . trim($str) . '</p>';

        // Multiple line breaks will be treated as paragraph.
        $str = preg_replace('~\n{2,}~', '</p><p>', $str);

        // Single line breaks will be converted to "<br />".
        return nl2br($str);
    }

    /**
     * Not needed.
     */
    protected function post()
    {
    }

    /**
     * Not needed.
     */
    protected function pre()
    {
    }
}
