[{isys type="f_text" p_bInvisible=true p_bInfoIconSpacer=0 name="template_id" id="template_id" p_bEditMode=1}]

<style type="text/css">
    .even {
        background-color: #f3f3f3;
    }
</style>

<div id="document_creation">
    <h3 class="bg-neutral-200 p5 border-bottom">[{isys type="lang" ident="LC__MODULE__DOCUMENT__DOCUMENT__CREATION_EDIT"}]</h3>

    <table class="contentTable">
	    <tr>
		    <td class="key">[{isys type="f_label" ident="LC__MODULE__DOCUMENT__DOCUMENT__DOCUMENT_TEMPLATE_TITLE" name="C__DOCUMENT__TITLE"}]</td>
		    <td class="value">[{isys type="f_text" name="C__DOCUMENT__TITLE"}]</td>
	    </tr>
	    <tr>
		    <td class="key">[{isys type="f_label" ident="LC__MODULE__DOCUMENT__DOCUMENT__TYPE" name="C__DOCUMENT__TYPE"}]</td>
		    <td class="value">[{isys type="f_dialog" name="C__DOCUMENT__TYPE" p_strTable="isys_document_type" p_bDisabled="1"}]</td>
	    </tr>
        [{if ($object_id)}]
        <tr>
            <td class="key">[{isys type="f_label" ident="LC__MODULE__DOCUMENT__CONNECTED_OBJECT"}]</td>
            <td class="value pl20">[{$assigned_object_url}]</td>
        </tr>
        [{/if}]
        <tr>
            <td class="key">[{isys type="f_label" ident="LC__MODULE__DOCUMENT__DOCUMENT_TEMPLATE"}]</td>
            <td class="value pl20">[{$template_url}]</td>
        </tr>
        <tr>
            <td class="key">[{isys type="f_label" ident="LC__CMDB__CATG__DOCUMENT__CREATION_REFRESH_DATE"}]</td>
            <td class="value pl20">[{$creation_date}]</td>
        </tr>
        [{if count($custom_field_data)}]
        <tr>
            <td colspan="2">
                <hr class="mt5 mb5" />
            </td>
        </tr>
        [{foreach $custom_field_data as $custom_field_name => $custom_field}]
        <tr>
            <td class="key">[{isys type="f_label" ident=$custom_field_name}]</td>
            <td class="value">[{$custom_field}]</td>
        </tr>
        [{/foreach}]
        <tr>
            <td colspan="2">
                <hr class="mt5 mb5" />
            </td>
        </tr>
        [{/if}]
        <tr>
            <td class="key vat">
                [{isys type="f_label" ident="LC__MODULE__DOCUMENT__DOCUMENT__DESCRIPTION" name="C__DOCUMENT__DESCRIPTION"}]
            </td>
            <td class="value">[{isys type="f_wysiwyg" name="C__DOCUMENT__DESCRIPTION"}]</td>
        </tr>
    </table>

	<ul id="documentTabs" class="m0 browser-tabs bg-neutral-200 border-top">
		<li><a href="#tab1">[{isys type="lang" ident="LC__MODULE__DOCUMENT__DOCUMENT__CURRENT_VERSION"}]</a></li>
		<li><a href="#tab2">[{isys type="lang" ident="LC__MODULE__DOCUMENT__DOCUMENT__REVISIONS"}]</a></li>
	</ul>

	<div id="tab1" class="p10 cb bg-white" style="overflow-x:auto">
		<h3>[{isys type="lang" ident="LC__MODULE__DOCUMENT__DOCUMENT__EXPORT_AS"}]:</h3>

		<p class="mt10">
	        <a class="btn mr5" href="[{$export_links.html_download}]">
	            <img src="[{$dir_images}]axialis/documents-folders/document-type-code-1.svg"><span>[{isys type="lang" ident="LC__MODULE__DOCUMENT__FORMAT__HTML"}]</span>
	        </a>
	        <a class="btn mr5" href="[{$export_links.pdf_download}]">
	            <img src="[{$dir_images}]axialis/documents-folders/document-type-pdf.svg"><span>[{isys type="lang" ident="LC__MODULE__DOCUMENT__FORMAT__PDF"}]</span>
	        </a>
			<a class="btn" href="[{$export_links.pdf_inline}]">
				<img src="[{$dir_images}]axialis/documents-folders/document-type-pdf.svg"><span>[{isys type="lang" ident="LC__MODULE__DOCUMENT__FORMAT__PDF"}] [{isys type="lang" ident="LC__MODULE__DOCUMENT__EXPORT_INLINE"}]</span>
			</a>
		</p>
	</div>

	<div id="tab2" class="p10 cb bg-white" style="overflow-x:auto">
		<table id="revision_table" class="listing" style="table-layout: fixed;">
			<colgroup>
                <col style="width:30px;" />
				<col style="width:150px;" />
				<col style="width:250px;" />
				<col style="width:280px;" />
			</colgroup>
            <thead>
            <tr>
                <th><input type="checkbox" id="document-master-checkbox" value="X" /></th>
                <th>[{isys type="lang" ident="LC__MODULE__DOCUMENT__POPUP_P__TEMPLATE_VAR__CREATION_DATE"}]</th>
                <th>[{isys type="lang" ident="LC__MODULE__DOCUMENT__REVISION_CREATOR"}]</th>
                <th>[{isys type="lang" ident="LC__MODULE__DOCUMENT__DOCUMENT__EXPORT_AS"}]</th>
                <th>[{isys type="lang" ident="LC__CATG__CONTACT_COMMENT"}]</th>
                <th>[{isys type="lang" ident="LC__MODULE__DOCUMENT__DOCUMENT_TEMPLATE__CUSTOM_FIELDS"}]</th>
            </tr>
            </thead>
            <tbody>
            [{foreach $revisions as $index => $revision}]
            <tr>
                <td>
                    <input type="checkbox" name="" class="document-revision-checkbox" value="[{$revision.isys_document_revision__id}]" />
                </td>
                <td>[{$revision.isys_document_revision__created}]</td>
                <td>
	                <a href="?objID=[{$revision.isys_cats_person_list__isys_obj__id}]" target="_blank">
		                <img src="[{$dir_images}]axialis/user-management/user.svg" class="vam" />
		                [{$revision.isys_cats_person_list__first_name}] [{$revision.isys_cats_person_list__last_name}]
	                </a>
                </td>
                <td>
                    <a class="btn mr5" href="[{$revision.html_download}]">
                        <img src="[{$dir_images}]axialis/documents-folders/document-type-code-1.svg">
                        <span>[{isys type="lang" ident="LC__MODULE__DOCUMENT__FORMAT__HTML"}]</span>
                    </a>
                    <a class="btn mr5" href="[{$revision.pdf_download}]">
                        <img src="[{$dir_images}]axialis/documents-folders/document-type-pdf.svg">
                        <span>[{isys type="lang" ident="LC__MODULE__DOCUMENT__FORMAT__PDF"}]</span>
                    </a>
	                <a class="btn" href="[{$revision.pdf_inline}]">
		                <img src="[{$dir_images}]axialis/documents-folders/document-type-pdf.svg">
                        <span>[{isys type="lang" ident="LC__MODULE__DOCUMENT__FORMAT__PDF"}] [{isys type="lang" ident="LC__MODULE__DOCUMENT__EXPORT_INLINE"}]</span>
	                </a>
                </td>
                <td>
                    <p>
                        [{$revision.isys_document_revision__comment}]
                    </p>
                </td>
                <td>
                    [{if count($revision.customFields)}]
                    <button type="button" class="btn" onclick="$(this).next().removeClassName('hide'); $(this).remove();">
                        <img src="[{$dir_images}]axialis/basic/eye.svg" /><span>[{isys type="lang" ident="LC__MODULE__DOCUMENT__CUSTOM_FIELDS__SHOW"}]</span>
                    </button>
                    <table class="w100 bg-white border hide" style="table-layout: fixed;" cellpadding="0" cellspacing="0">
                        <thead>
                        <th>[{isys type="lang" ident="LC__MODULE__DOCUMENT__CUSTOM_FIELDS__NAME"}]</th>
                        <th>[{isys type="lang" ident="LC__MODULE__DOCUMENT__CUSTOM_FIELDS__VALUE"}]</th>
                        </thead>
                        <tbody>
                        [{foreach $revision.customFields as $key => $value}]
                        <tr>
                            <td>[{$key}]</td>
                            <td>[{$value}]</td>
                        </tr>
                        [{/foreach}]
                        </tbody>
                    </table>
                    [{else}]
                        <span class="text-neutral-400">-</span>
                    [{/if}]
                </td>
                </tr>
                [{/foreach}]
            </tbody>
        </table>
	</div>
</div>

<script type="text/javascript">
    (function () {
        "use strict";

        var $regenerateRevisionButton = $('navbar_item_regenerate_document'),
            $deleteButton = $('navbar_item_C__NAVMODE__DELETE'),
            $masterCheckbox = $('document-master-checkbox'),
            $checkboxes = $('revision_table').select('.document-revision-checkbox');

	    if ($('documentTabs')) {
		    new Tabs('documentTabs', {
			    wrapperClass: 'browser-tabs',
			    contentClass: 'browser-tab-content',
			    tabClass: 'mouse-pointer'
		    });
	    }

        $masterCheckbox.on('click', function () {
            $checkboxes.invoke('setValue', ($masterCheckbox.checked ? 1 : 0));
	    });

        if ($deleteButton) {
            $deleteButton.on('click', function () {
                var $popup = $('popup'),
                    $checkedCheckboxes = $checkboxes.filter(function($checkbox) { return $checkbox.checked; });

                if ($checkedCheckboxes.length) {
                    if (confirm('[{isys type="lang" ident="LC__MODULE__DOCUMENT__REVISION_REMOVE"}]')) {
                        var revision_selection = $checkedCheckboxes.invoke('readAttribute', 'value');

                        new Ajax.Request('?[{$smarty.const.C__GET__MODULE_ID}]=[{$smarty.const.C__MODULE__DOCUMENT}]&ajax=1&call=document&method=deleteRevision', {
                            method:     'post',
                            parameters: {
                                revisionIDs: Object.toJSON(revision_selection)
                            },
                            onComplete:  function (transport) {
                                if (transport.responseText == '') {
                                    location.reload();
                                } else {
                                    idoit.Notify.error("[{isys type="lang" ident="LC__MODULE__DOCUMENT__DOCUMENT_CREATION__REGENERATION_FAIL"}]" +
                                                       transport.responseText);
                                }
                            }
                        });
                    }
                } else {
                    idoit.Notify.error("[{isys type="lang" ident="LC__MODULE__DOCUMENT__ERROR__NO_REVISIONS_SELECTED"}]");
                }
            });
        }

        if ($regenerateRevisionButton) {
            var commentable = [{isys_tenantsettings::get('idoit.addon.document.revision.commentable', 0)|intval}];

            idoit.callbackManager.registerCallback('create_revision', function (revision_reason, comment) {
                $regenerateRevisionButton.disable()
                    .down('img').addClassName('animation-rotate')
                    .writeAttribute('src', window.dir_images + 'axialis/user-interface/loading.svg');

                new Ajax.Request('?[{$smarty.const.C__GET__MODULE_ID}]=[{$smarty.const.C__MODULE__DOCUMENT}]&[{$smarty.const.C__GET__AJAX}]=1&[{$smarty.const.C__GET__AJAX_CALL}]=document&method=regenerateDocument', {
                    method:     'post',
                    parameters: {
                        '[{$smarty.const.C__DOCUMENT__GET__DOCUMENT_ID}]': '[{$document_id}]',
                        'revisionReason':                                  revision_reason,
                        'comment':                                         comment
                    },
                    onComplete:  function (transport) {
                        $regenerateRevisionButton.enable()
                            .down('img').removeClassName('animation-rotate')
                            .writeAttribute({src: '[{$dir_images}]axialis/basic/symbol-update.svg'});

                        if (transport.responseText.blank()) {
                            idoit.Notify.success("[{isys type="lang" ident="LC__MODULE__DOCUMENT__DOCUMENT_CREATION__REGENERATION_SUCCESS"}]");

                            location.reload();
                        } else {
                            idoit.Notify.error("[{isys type="lang" ident="LC__MODULE__DOCUMENT__DOCUMENT_CREATION__REGENERATION_FAIL"}]" + transport.responseText);
                        }
                    }
                });
            });

            $regenerateRevisionButton.on('click', function () {
                if (commentable === 1) {
                    get_popup('document_revision_comment', 'editMode=1&callbackAccept=create_revision', 500, 300, null, 'popup_commentary');
                } else {
                    idoit.callbackManager.triggerCallback('create_revision');
                }
            });
        }
    }());
</script>
