[{isys_group name="tom.popup.placeholder"}]
<div id="document-popup">
    <div class="popup-header-ng">
        <h1>[{isys type="lang" ident="LC__MODULE__DOCUMENT__POPUP_P__MAINOBJECT__HEADER"}]</h1>
        <button type="button" class="btn btn-secondary popup-closer ml-auto" title="[{isys type="lang" ident="LC__POPUP__CLOSE"}]" data-tooltip="1">
            <img class="fr mouse-pointer" alt="" src="[{$dir_images}]axialis/user-interface/window-control-close.svg" />
        </button>
    </div>

	<div class="popup-content">
		<div class="p10">
			[{isys type="f_property_selector" name="document_popup_property_selector"}]
		</div>

		<hr class="mt5 mb5" />

		<div class="p10 pt0">
            <label class="display-block p5">
                <input type="checkbox" id="document_show_only_primary_entry">
                <span>[{isys type="lang" ident="LC__MODULE__DOCUMENT__SHOW_ONLY_PRIMARY_ENTRY"}]</span>
            </label>

			<label class="display-block p5">
				<input type="checkbox" id="document_property_view_type">
				<span>[{isys type="lang" ident="LC__MODULE__DOCUMENT__POPUP_P__MAINOBJECT__DISPLAY_AS_TABLE"}]</span>
			</label>

			<div class="p10" id="document_property_options">
				<div class="overlay"></div>

                <h2 class="mt10 mb10">[{isys type="lang" ident="LC__MODULE__DOCUMENT__ENTRIES_STATUS"}]</h2>

                <div>
                    <label class="display-block p5">
                        <input type="checkbox" name="status[]" value="2" checked="checked" />
                        [{isys type="lang" ident="LC__CMDB__RECORD_STATUS__NORMAL"}]
                    </label>
                    <label class="display-block p5">
                        <input type="checkbox" name="status[]" value="3" />
                        [{isys type="lang" ident="LC__CMDB__RECORD_STATUS__ARCHIVED"}]
                    </label>
                    <label class="display-block p5">
                        <input type="checkbox" name="status[]" value="4" />
                        [{isys type="lang" ident="LC__CMDB__RECORD_STATUS__DELETED"}]
                    </label>
                </div>

				<table class="contentTable">
                    <tr>
                        <td colspan="2">
                            <hr class="mt5 mb5" />
                        </td>
                    </tr>
                    <tr>
                        <td class="key"><label>[{isys type="lang" ident="LC__MODULE__DOCUMENT__CONDITIONAL_MESSAGE"}]</label></td>
                        <td class="value">[{isys type="checkbox" name="is_conditional_message_required"}]</td>
                    </tr>
                    <tr>
                        <td colspan="2" class="text-center">
                            <strong>[{isys type="lang" ident="LC__MODULE__DOCUMENT__CONDITIONAL_MESSAGE_EMPTY"}]</strong>
                        </td>
                    </tr>
                    <tr>
                        <td class="key"><label>Text</label></td>
                        <td class="value">[{isys type="f_text" name="conditional_message_empty"}]</td>
                    </tr>
                    <tr>
                        <td colspan="2" class="text-center">
                            <strong>[{isys type="lang" ident="LC__MODULE__DOCUMENT__CONDITIONAL_MESSAGE_FULL"}]</strong>
                        </td>
                    </tr>
                    <tr>
                        <td class="key"><label>[{isys type="lang" ident="LC__MODULE__DOCUMENT__CONDITIONAL_MESSAGE_FULL_TOP"}]</label></td>
                        <td class="value">[{isys type="f_text" name="conditional_message_full_top"}]</td>
                    </tr>
                    <tr>
                        <td class="key"><label>[{isys type="lang" ident="LC__MODULE__DOCUMENT__CONDITIONAL_MESSAGE_FULL_BOTTOM"}]</label></td>
                        <td class="value">[{isys type="f_text" name="conditional_message_full_bottom"}]</td>
                    </tr>
                    <tr>
                        <td colspan="2">
                            <hr class="mt5 mb5" />
                        </td>
                    </tr>
					<tr>
						<td class="key">[{isys type="f_label" name="document_property_options_header" ident="LC__MODULE__DOCUMENT__POPUP_P__MAINOBJECT__DISPLAY_COLUMN_HEADERS"}]</td>
						<td class="value">
							[{isys type="checkbox" name="document_property_options_header"}]

							<button type="button" class="btn header-style ml10" value="b" title="bold" data-tooltip="1"><img src="[{$dir_images}]axialis/word-processing/character-bold.svg" /></button>
							<button type="button" class="btn header-style" value="i" title="italic" data-tooltip="1"><img src="[{$dir_images}]axialis/word-processing/character-italic.svg" /></button>
							<button type="button" class="btn header-style" value="u" title="underline" data-tooltip="1"><img src="[{$dir_images}]axialis/word-processing/character-underline.svg" /></button>

							<button type="button" class="btn header-alignment ml10" value="left" data-tooltip="1" title="[{isys type="lang" ident="LC__MODULE__DOCUMENT__PLACEHOLDER__REPORT__HEADER_ALIGN_LEFT" p_bHtmlEncode=false}]">
								<img src="[{$dir_images}]axialis/word-processing/paragraph-align-left.svg" />
							</button>
							<button type="button" class="btn header-alignment" value="center" data-tooltip="1" title="[{isys type="lang" ident="LC__MODULE__DOCUMENT__PLACEHOLDER__REPORT__HEADER_ALIGN_CENTER" p_bHtmlEncode=false}]">
								<img src="[{$dir_images}]axialis/word-processing/paragraph-align-center.svg" />
							</button>
							<button type="button" class="btn header-alignment" value="right" data-tooltip="1" title="[{isys type="lang" ident="LC__MODULE__DOCUMENT__PLACEHOLDER__REPORT__HEADER_ALIGN_RIGHT" p_bHtmlEncode=false}]">
								<img src="[{$dir_images}]axialis/word-processing/paragraph-align-right.svg" />
							</button>
						</td>
					</tr>
					<tr>
						<td class="key">[{isys type="f_label" ident="LC__MODULE__DOCUMENT__PLACEHOLDER__REPORT__HEADER_BACKGROUND" name="document-popup-report-header-background"}]</td>
						<td class="value">[{isys type="f_text" name="document-popup-report-header-background"}]</td>
					</tr>
					<tr>
						<td class="key">[{isys type="f_label" ident="LC__MODULE__DOCUMENT__PLACEHOLDER__REPORT__HEADER_TEXTCOLOR" name="document-popup-report-header-textcolor"}]</td>
						<td class="value">[{isys type="f_text" name="document-popup-report-header-textcolor"}]</td>
					</tr>
					<tr>
						<td colspan="2">
							<hr class="mt5 mb5" />
						</td>
					</tr>
					<tr>
						<td class="key">[{isys type="f_label" name="document_property_options_border" ident="LC__MODULE__DOCUMENT__PLACEHOLDER__REPORT__DISPLAY_GRID"}]</td>
						<td class="value">[{isys type="f_dialog" name="document_property_options_border"}]</td>
					</tr>
					<tr>
						<td class="key">[{isys type="f_label" ident="LC__MODULE__DOCUMENT__PLACEHOLDER__REPORT__ZEBRA_GRID" name="document-popup-report-zebra-grid"}]</td>
						<td class="value">[{isys type="f_text" name="document-popup-report-zebra-grid"}]</td>
					</tr>
					<tr>
						<td class="key">[{isys type="f_label" ident="LC__MODULE__DOCUMENT__PLACEHOLDER__REPORT__DISPLAY_AFTER_PAGE_BREAK" name="document-popup-report-show-after-page-break"}]</td>
						<td class="value">[{isys type="f_dialog" name="document-popup-report-show-after-page-break"}]</td>
					</tr>
				</table>
			</div>
		</div>
	</div>
	<div class="popup-footer-ng">
		<button type="button" class="btn mr5" id="document-popup-save-button">
			<img src="[{$dir_images}]axialis/basic/symbol-ok.svg"><span>[{isys type="lang" ident="LC__MODULE__DOCUMENT__POPUP_P__EXTERNALOBJECT__EMBED"}]</span>
		</button>
		<button type="button" class="btn popup-closer">
			<img src="[{$dir_images}]axialis/basic/symbol-cancel.svg"><span>[{isys type="lang" ident="LC__UNIVERSAL__BUTTON_CANCEL"}]</span>
		</button>
	</div>
</div>
<style type="text/css">
	#document_property_options {
		position: relative;
	}

	#document_property_options .overlay {
		position: absolute;
		top: 0;
		bottom: 0;
		left: 0;
		right: 0;
		background: rgba(255, 255, 255, .75);
		z-index: 100;
	}
</style>
<script type="text/javascript">
    (function () {
        "use strict";

        var $popup                      = $('document-popup').stopObserving(),
            $content                    = $popup.down('.popup-content'),
            widget                      = window.currently_selected_document_widget,
            widgetData                  = widget.data,
            editor                      = widget.editor,
            widget_to_add               = [],
            cnt                         = 0,
            $statusCheckboxes           = $('document_property_options').select('[name="status[]"]'),
            $viewType                   = $('document_property_view_type'),
            $options                    = $('document_property_options'),
            $optionsOverlay             = $options.down('.overlay'),
            $optionDisplayHeader        = $('document_property_options_header'),
            $reportHeaderBackground     = $('document-popup-report-header-background'),
            $reportHeaderTextcolor      = $('document-popup-report-header-textcolor'),
            $showGrid                   = $('document_property_options_border'),
            $zebraGrid                  = $('document-popup-report-zebra-grid'),
            $showAfterPageBreak         = $('document-popup-report-show-after-page-break'),
            multiValueCategories        = JSON.parse('[{$multiValueCategories|json_encode|escape:"javascript"}]'),
            $showOnlyPrimaryEntry       = $('document_show_only_primary_entry');

        // Observe the addition of attributes, to check the "display as table" checkbox.
        $popup.on('click', '.plus', function (ev) {
            var $tab = ev.findElement('.browser-tab-content'),
                $select;

            if (!$tab) {
                return;
            }

            $select = $tab.down('select');

            if ($select) {
                if (multiValueCategories.indexOf($select.getValue()) !== -1) {
                    $viewType.setValue(1);
                    $viewType.simulate('change');
                }
            }
        });

        function setConditionalFieldsDisabled(disabled) {
            $('conditional_message_empty').disabled = disabled;
            $('conditional_message_full_top').disabled = disabled;
            $('conditional_message_full_bottom').disabled = disabled;
        }

        $('is_conditional_message_required').on('change', function (evt) {
            var checked = evt.target.checked;
            if (checked) {
                setConditionalFieldsDisabled(false);
            } else {
                setConditionalFieldsDisabled(true);
            }
        });

        // Here we reformat possible old configurations to fit the new ones:
        if (widgetData.type === 'category') {
            $optionsOverlay.addClassName('hide');
            $viewType.setValue(1);
        }

        if (widgetData.data.hasOwnProperty('optBorder')) {
            widgetData.data.showGrid = (widgetData.data.optBorder ? 'all' : 0);
        }

        // Preselection.
        if (!widgetData.data.hasOwnProperty('optHeader')) {
            widgetData.data.optHeader = false;
        }

        if (!widgetData.data.hasOwnProperty('headerTextAlignment')) {
            widgetData.data.headerTextAlignment = 'left';
        }

        if (!widgetData.data.hasOwnProperty('headerTextStyle')) {
            widgetData.data.headerTextStyle = 'b';
        }

        if (!widgetData.data.hasOwnProperty('headerBackground')) {
            widgetData.data.headerBackground = 'ffffff';
        }

        if (!widgetData.data.hasOwnProperty('headerTextcolor')) {
            widgetData.data.headerTextcolor = '000000';
        }

        if (!widgetData.data.hasOwnProperty('showGrid')) {
            widgetData.data.showDescription = 'all';
        }

        if (!widgetData.data.hasOwnProperty('zebraGrid')) {
            widgetData.data.showDescription = 'ffffff';
        }

        if (!widgetData.data.hasOwnProperty('showAfterPageBreak')) {
            widgetData.data.showAfterPageBreak = 1;
        }

        if (!widgetData.hasOwnProperty('showOnlyPrimaryEntry')) {
            widgetData.showOnlyPrimaryEntry = 0;
        }

        if (widgetData.data.hasOwnProperty('status') && Object.isArray(widgetData.data['status']) && widgetData.data['status'].length !== 0) {
            $statusCheckboxes.invoke('setValue', 0);

            $statusCheckboxes.filter(function($checkbox) {
                return widgetData.data['status'].indexOf($checkbox.readAttribute('value')) >= 0;
            }).invoke('setValue', 1);
        }

        try {
            $popup.down('.btn.header-alignment[value="' + widgetData.data.headerTextAlignment + '"]').addClassName('pressed');
        } catch (e) {
            $popup.down('.btn.header-alignment').addClassName('pressed');
        }

        if (widgetData.data.headerTextStyle.indexOf('b') >= 0) {
            $popup.down('.btn.header-style').addClassName('pressed')
        }

        if (widgetData.data.headerTextStyle.indexOf('i') >= 0) {
            $popup.down('.btn.header-style', 1).addClassName('pressed')
        }

        if (widgetData.data.headerTextStyle.indexOf('u') >= 0) {
            $popup.down('.btn.header-style', 2).addClassName('pressed')
        }

        $optionDisplayHeader.on('change', function () {
            if ($optionDisplayHeader.checked) {
                $reportHeaderBackground.enable();
                $reportHeaderTextcolor.enable();
                $options.select('.btn').invoke('enable');
            } else {
                $reportHeaderBackground.disable();
                $reportHeaderTextcolor.disable();
                $options.select('.btn').invoke('disable');
            }
        });

        $optionDisplayHeader.setValue(widgetData.data.optHeader ? 1 : 0).simulate('change');
        $reportHeaderBackground.setValue(widgetData.data.headerBackground);
        $reportHeaderTextcolor.setValue(widgetData.data.headerTextcolor);
        $showGrid.setValue(widgetData.data.showGrid);
        $zebraGrid.setValue(widgetData.data.zebraGrid);
        $showAfterPageBreak.setValue(widgetData.data.showAfterPageBreak);
        $showOnlyPrimaryEntry.setValue(widgetData.showOnlyPrimaryEntry ? widgetData.showOnlyPrimaryEntry: 0);
        $('conditional_message_empty').setValue(widgetData.data.conditionalMessageEmpty);
        $('conditional_message_full_top').setValue(widgetData.data.conditionalMessageFullTop);
        $('conditional_message_full_bottom').setValue(widgetData.data.conditionalMessageFullBottom);
        $('is_conditional_message_required').checked = widgetData.data.isConditionalMessage;

        if ($('is_conditional_message_required').checked == true) {
            setConditionalFieldsDisabled(false);
        } else {
            setConditionalFieldsDisabled(true);
        }

        // Initiate the color picker (after the values have been set).
        jscolor.init();

        // Add the chosen plugins.
        $content.select('select.chosen-select').each(function (element) {
            new Chosen(element, {
                disable_search_threshold: 10,
                width:                    '280px',
                search_contains:          true
            });
        });

        $popup.on('click', '.btn.header-alignment', function (ev) {
            $popup.select('.btn.header-alignment').invoke('removeClassName', 'pressed');

            ev.findElement('button').addClassName('pressed');
        });

        $popup.on('click', '.btn.header-style', function (ev) {
            ev.findElement('button').toggleClassName('pressed');
        });

        // Register a callback for "closing" the popup.
        $popup.select('.popup-closer').invoke('on', 'click', function () {
            // If the user closes the popup, we want to destroy the widget!
            if (widget.data.data && widget.data.data.hasOwnProperty('catg') && widget.data.data.catg.trim() === '') {
                widget.remove_and_set_focus();
            }

            popup_close($('popup_placeholder'));

            window.currentEditor.focus();
        });

        // Observer for the checkbox
        $viewType.on('change', function () {
            if ($viewType.checked) {
                $optionsOverlay.addClassName('hide');
            } else {
                $optionsOverlay.removeClassName('hide');

                if (hasMultiValueCategoryProperties()) {
                    idoit.Notify.info('[{isys type="lang" ident="LC__MODULE__DOCUMENT__PLACEHOLDER__MULTIVALUE_CATEGORY_WITHOUT_TABLE_INFO"}]', {life: 10});
                }
            }
        });

        // And add some "accept" logic.
        $('document-popup-save-button').on('click', function (ev) {
            ev.preventDefault();

            var data       = {},
                property,
                properties = JSON.parse($F('document_popup_property_selector__COMPLETE') || '{}');

            if (!$viewType.checked)
            {
                var category_type, ref_key, i, i2;

                for (i in properties.root) {
                    if (properties.root.hasOwnProperty(i)) {
                        property = properties.root[i];

                        if (property.g) {
                            category_type = 'g';
                        } else if (property.s) {
                            category_type = 's';
                        } else if (property.c) {
                            category_type = 'c';
                        } else if (property.g_custom) {
                            category_type = 'g_custom';
                        } else {
                            idoit.Notify.error('Unknown property: ' + JSON.stringify(property));

                            continue;
                        }

                        for (i2 in property[category_type]) {
                            if (property[category_type].hasOwnProperty(i2)) {
                                // The ref key looks like "<cat-const>-<cat-prop>".
                                ref_key = i2 + '-' + property[category_type][i2][1];

                                if (properties.hasOwnProperty(ref_key)) {
                                    prepare_widget_child(properties, i2, category_type, property, ref_key);
                                } else {
                                    prepare_widget(properties, i2, category_type, property, '');
                                }
                            }
                        }
                    }
                }

                // This function will add the prepared widgets to the CKE.
                add_widgets();
            } else {
                var a, a2, a3, property_arr,
                    chained_category_title_arr, chained_category_title = [], chained_category_title_string = '';
                // Input a complete category table.
                for (a in properties) {
                    if (properties.hasOwnProperty(a)) {
                        property_arr = properties[a];

                        for (a2 in property_arr) {
                            if (property_arr.hasOwnProperty(a2)) {
                                property = property_arr[a2];

                                if (property.g) {
                                    category_type = 'g';
                                } else if (property.s) {
                                    category_type = 's';
                                } else if (property.c) {
                                    category_type = 'c';
                                } else if (property.g_custom) {
                                    category_type = 'g_custom';
                                } else {
                                    idoit.Notify.error('Unknown property: ' + JSON.stringify(property));

                                    continue;
                                }

                                for (a3 in property[category_type]) {
                                    if (property[category_type].hasOwnProperty(a3)) {
                                        chained_category_title_arr = property[category_type][a3][2].split('(');
                                        chained_category_title_string = chained_category_title_arr[1].substr(0, (chained_category_title_arr[1].length - 1));

                                        if (chained_category_title.indexOf(chained_category_title_string) < 0) {
                                            chained_category_title.push(chained_category_title_string);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }

                // Get chosen status values
                var checkedStatusInputs = $$('input[name="status[]"]:checked'),
                    status = [];

                if (checkedStatusInputs.length !== 0) {
                    checkedStatusInputs.forEach(function(input) {
                        status.push(input.value);
                    });
                }

                data = {
                    widget_type:          'masterObject',
                    type:                 'category',
                    showOnlyPrimaryEntry: !!$showOnlyPrimaryEntry.getValue(),
                    data:                 {
                        catgName:                     chained_category_title.join(', '),
                        optHeader:                    $optionDisplayHeader.checked,
                        headerBackground:             $reportHeaderBackground.getValue(),
                        headerTextcolor:              $reportHeaderTextcolor.getValue(),
                        headerTextAlignment:          $popup.down('.btn.header-alignment.pressed').getValue(),
                        headerTextStyle:              $popup.select('.btn.header-style.pressed').invoke('getValue').join(''),
                        showGrid:                     $showGrid.getValue(),
                        zebraGrid:                    $zebraGrid.getValue(),
                        showAfterPageBreak:           $showAfterPageBreak.getValue(),
                        propData:                     $F('document_popup_property_selector__COMPLETE'),
                        objID:                        null,
                        status:                       status,
                        isConditionalMessage:         $('is_conditional_message_required').checked,
                        conditionalMessageEmpty:      $F('conditional_message_empty'),
                        conditionalMessageFullTop:    $F('conditional_message_full_top'),
                        conditionalMessageFullBottom: $F('conditional_message_full_bottom')
                    }
                };
            }

            widget.setData(data);

            popup_close($('popup_placeholder'));

            window.currentEditor.focus();
        });

        // Three functions for preparing and adding the widgets.
        var prepare_widget = function (properties, category_constant, category_type, property, parent_ref_key) {
                var title = '';

                if (parent_ref_key) {
                    title = generatePlaceholderTitleForSingleProperty(properties);
                }

                var widgetData = {
                    type: 'property',
                    data: {
                        catg:      category_constant,
                        catg_type: category_type,
                        prop:      property[category_type][category_constant][1],
                        propName:  (parent_ref_key ? title : property[category_type][category_constant][2]),
                        objID:     null
                    }
                };

                if (!parent_ref_key.blank()) {
                    widgetData.data.refKey = parent_ref_key;
                }

                widget_to_add.push(widgetData);
            },
            prepare_widget_child = function (properties, category_constant, category_type, property, parent_ref_key) {
                var ref_key,
                    i, i2;

                for (i in properties[parent_ref_key]) {
                    if (properties[parent_ref_key].hasOwnProperty(i)) {
                        property = properties[parent_ref_key][i];

                        if (property.g) {
                            category_type = 'g';
                        } else if (property.s) {
                            category_type = 's';
                        } else if (property.c) {
                            category_type = 'c';
                        } else if (property.g_custom) {
                            category_type = 'g_custom';
                        } else {
                            idoit.Notify.error('Unknown property: ' + JSON.stringify(property));

                            continue;
                        }

                        for (i2 in property[category_type]) {
                            if (property[category_type].hasOwnProperty(i2)) {
                                ref_key = parent_ref_key + '--' + i2 + '-' + property[category_type][i2][1];

                                if (properties.hasOwnProperty(ref_key)) {
                                    prepare_widget_child(properties, i2, category_type, property, ref_key);
                                } else {
                                    prepare_widget(properties, i2, category_type, property, parent_ref_key);
                                }
                            }
                        }
                    }
                }
            },
            add_widgets = function () {
                var i, data;

                for (i in widget_to_add) {
                    if (widget_to_add.hasOwnProperty(i)) {
                        // Because one widget is already existing, we skip the creation of the first placeholder.
                        if (cnt === 0) {
                            data = Object.clone(widget_to_add[i]);
                        } else {
                            // We create a "widget-like" element, add it to the editor and initialize it as widget.
                            var element = editor.document.createElement('span', {
                                    attributes: {
                                        "class":            "document-wysiwyg-placeholder",
                                        "data-widget-type": "masterObject",
                                        "data-json":        JSON.stringify(widget_to_add[i])
                                    }
                                }
                            );

                            // We need to add the new element after the widget-parent, because its
                            element.insertAfter(widget.element.getParent());

                            editor.widgets.initOn(element, 'masterObject');
                        }

                        cnt++;
                    }
                }
                data['showOnlyPrimaryEntry'] = !!$showOnlyPrimaryEntry.getValue();

                widget.setData(data);
            },
            generatePlaceholderTitleForSingleProperty = function (properties) {
                var a, property, categoryType, propertyInfo, propertiesLength = Object.keys(properties).length, title = [], titlePart;

                for (a in properties) {
                    if (properties.hasOwnProperty(a))
                    {
                        property = properties[a][0];

                        if (property.g) {
                            categoryType = 'g';
                        } else if (property.s) {
                            categoryType = 's';
                        } else if (property.c) {
                            categoryType = 'c';
                        } else if (property.g_custom) {
                            categoryType = 'g_custom';
                        } else {
                            idoit.Notify.error('Unknown property: ' + JSON.stringify(property));

                            continue;
                        }

                        titlePart = property[categoryType][Object.keys(property[categoryType])[0]][2];

                        if (propertiesLength === 1) {
                            title.push(titlePart);
                        } else {
                            // Fetch the content of all brackets.
                            titlePart = titlePart.match(/\(.*?\)/g);

                            // But only take the last value.
                            titlePart = titlePart[titlePart.length - 1];

                            // And remove the brackets.
                            title.push(titlePart.substr(1, (titlePart.length - 2)));
                        }
                        propertiesLength--;
                    }
                }
                return title.join(' > ');
            };

        function hasMultiValueCategoryProperties() {
            var $selectionList = $('document_popup_property_selector_selection_field'),
                $multiValueEntries;

            if ($selectionList) {
                $multiValueEntries = $selectionList.select('.property').filter(function ($property) {
                    return multiValueCategories.indexOf($property.readAttribute('data-catconst')) !== -1;
                });

                if ($multiValueEntries.length) {
                    return true;
                }
            }

            return false;
        }
    })();
</script>
[{/isys_group}]
