<?php

use idoit\Module\Document\CustomFields\Repository\CustomFieldsRepository;

/**
 * i-doit
 *
 * CMDB CPU category.
 *
 * @package     i-doit
 * @subpackage  CMDB_Categories
 * @author      Selcuk Kekec <skekec@i-doit.org>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_cmdb_ui_category_g_document extends isys_cmdb_ui_category_global
{
    /**
     * Process method.
     *
     * @param   isys_cmdb_dao_category $p_cat
     *
     * @return  void
     * @author  Selcuk Kekec <skekec@i-doit.org>
     */
    public function process(isys_cmdb_dao_category $p_cat)
    {
        global $g_dirs;

        $l_rules = [];
        $l_catdata = $p_cat->get_general_data();

        $locales = isys_application::instance()->container->get('locales');

        $this->fill_formfields($p_cat, $l_rules, $l_catdata);

        // Make rules.
        $l_rules['C__DOCUMENT__DESCRIPTION']['p_strValue'] = $l_catdata['isys_document__description'];
        $l_rules['C__DOCUMENT__TYPE']['p_strSelectedID'] = $l_catdata['isys_document__isys_document_type__id'];
        $l_rules['C__CMDB__CAT__COMMENTARY_' . $p_cat->get_category_type() . $p_cat->get_category_id()]['p_strValue'] = $l_catdata['isys_catg_document_list__description'];

        $l_revision_res = isys_document_dao_revision::instance($this->m_database_component)->get_revisions_of_document($l_catdata['isys_document__id']);

        $l_revisions = [];

        if ($l_revision_res->count()) {
            while ($l_row = $l_revision_res->get_row()) {
                $l_row['isys_document_revision__created'] = $locales->fmt_datetime($l_row['isys_document_revision__created']);
                $l_revisions[] = $l_row + isys_module_document::get_export_links($l_catdata['isys_document__id'], $l_row['isys_document_revision__id']);
            }
        }

        $assignedObjectLink = '<a href="' . isys_helper_link::create_url([C__CMDB__GET__OBJECT => $l_catdata['isys_obj__id']]) . '">' .
            '<img src="' . $g_dirs['images'] . 'axialis/basic/link.svg" alt="Link" class="vam mr5" /><span class="vam">' . $l_catdata['isys_obj__title'] . '</span>' .
            '</a>';

        $templateLinkUrl = [
            C__GET__MODULE_ID      => C__MODULE__DOCUMENT,
            C__GET__SETTINGS_PAGE  => isys_module_document::CL__ACTION__DOCUMENT_TEMPLATES,
            'action'               => 'edit',
            'id'                   => $l_catdata['isys_document_template__id'],
            C__CMDB__GET__TREEMODE => C__MODULE__DOCUMENT . '00000' . $l_catdata['isys_document_type__id'],
        ];

        $templateLink = '<a href="' . isys_helper_link::create_url($templateLinkUrl) . '">' .
            '<img src="' . $g_dirs['images'] . 'axialis/basic/link.svg" class="vam mr5" /><span>' . $l_catdata['isys_document_template__title'] . '</span>' .
            '</a>';

        /**
         * @see  DOKU-355 Implement the custom fields in the document category.
         */
        $customFieldsHtml = [];

        if ($l_catdata['isys_document_template__id'] > 0) {
            $customFieldRepository = new CustomFieldsRepository();
            $customFields = $customFieldRepository->getCustomFieldsForDocument($l_catdata['isys_document__id']);

            foreach ($customFields as $customField) {
                $customFieldsHtml[$customField->getName()] = $customField->getValue()->getTemplate(
                    'custom-field[' . $customField->getId() . ']',
                    $customField->getValue()->getStringValue() ?: $customField->getDefaultValue()->getStringValue(),
                    isys_glob_is_edit_mode()
                );
            }
        }

        $this->deactivate_commentary()
            ->get_template_component()
            ->assign('assigned_object_url', $assignedObjectLink)
            ->assign('document_id', $l_catdata['isys_document__id'])
            ->assign('object_id', $l_catdata['isys_obj__id'])
            ->assign('revisions', $l_revisions)
            ->assign('export_links', isys_module_document::get_export_links($l_catdata['isys_document__id']))
            ->assign('creation_date', $locales->fmt_datetime($l_catdata['isys_document__created']))
            ->assign('template_url', $templateLink)
            ->assign('customFields', $customFieldsHtml)
            ->smarty_tom_add_rules('tom.content.bottom.content', $l_rules)
            ->include_template('contentbottomcontent', $this->get_template());

        // @see  DOKU-371  Only allow to create new revisions, if the user has the edit right.
        if (isys_module_document::getAuth()->is_allowed_to(isys_auth::EDIT, 'DOCUMENTS/' . $l_catdata['isys_document__id'])) {
            // Document-Refresh button.
            isys_component_template_navbar::getInstance()
                ->append_button(_L('LC__MODULE__DOCUMENT__DOCUMENT__REGENERATE_DOCUMENT'), 'regenerate_document', [
                        'active'     => true,
                        'visible'    => true,
                        'icon'       => 'axialis/basic/symbol-update.svg',
                        'js_onclick' => ';',
                        'navmode'    => 'regenerate_document'
                    ]);
        }
    }

    /**
     * Get path to template file.
     *
     * @return  string
     * @author  Selcuk Kekec <skekec@i-doit.com>
     */
    public function get_template()
    {
        return isys_module_document::getPath() . 'templates/modules/cmdb/catg__document.tpl';
    }
}
