<?php

/**
 * Interface isys_document_formattable.
 *
 * @package     i-doit
 * @subpackage  Modules
 * @version     1.1
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
interface isys_document_formattable
{
    /**
     * @param array $options
     *
     * @return void
     */
    public function initialize(array $options): void;

    /**
     * Write formatted content to $p_filename.
     *
     * @param string $filename
     *
     * @return $this
     */
    public function save(string $filename): self;

    /**
     * Send formatted content to browser.
     *
     * @param string  $filename
     * @param boolean $inline
     *
     * @return $this
     */
    public function send(string $filename, bool $inline): self;

    /**
     * Add Chapter heading.
     *
     * @param string $title
     * @param string $pos
     * @param int    $level
     *
     * @return $this
     */
    public function addHeadline(string $title, string $pos, int $level): self;

    /**
     * Add Chapter content.
     *
     * @param string $text
     *
     * @return self
     */
    public function addContent(string $text): self;

    /**
     * Called after exporting/formatting.
     *
     * @return self
     */
    public function afterExport(): self;

    /**
     * Called before exporting/formatting.
     *
     * @return self
     */
    public function beforeExport(): self;

    /**
     * Retrieves the format option definition for the current formatter.
     *
     * @return array
     */
    public function getFormatOptionDefinition(): array;

    /**
     * Adds a new page for the chapter if defined.
     *
     * @return self
     */
    public function addNewPage(): self;

    /**
     * Method for returning the current content.
     *
     * @return string
     */
    public function getContent(): string;
}
