<?php

/**
 * i-doit
 *
 * Popup class for creating new documents
 *
 *
 * @package     i-doit
 * @subpackage  Popups
 * @author      Selcuk Kekec <skekec@i-doit.de>
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @version     1.0
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_popup_document_create_document extends isys_component_popup
{
    /**
     * @param  isys_module_request $moduleRequest
     *
     * @return void
     * @throws isys_exception_database
     */
    public function &handle_module_request(isys_module_request $moduleRequest)
    {
        $objectId = (isset($_GET[C__CMDB__GET__OBJECT]) && $_GET[C__CMDB__GET__OBJECT] ? (int)$_GET[C__CMDB__GET__OBJECT] : null);
        $documentTypeId = (isset($_GET['documentTypeID']) && $_GET['documentTypeID'] ? (int)$_GET['documentTypeID'] : null);
        $documentTemplateId = (isset($_GET['documentTemplateID']) && $_GET['documentTemplateID'] ? (int)$_GET['documentTemplateID'] : null);
        $documentTemplateData = [];
        $documentTemplateDisabledData = [];
        $documentTemplateResult = isys_document_dao_templates::instance($this->database)->get_data(null, $documentTypeId);

        // Get templates.
        if (count($documentTemplateResult)) {
            while ($l_document_template_row = $documentTemplateResult->get_row()) {
                if (!isys_document_dao_chapters::instance($this->database)->get_data(null, $l_document_template_row['isys_document_template__id'])->num_rows()) {
                    $documentTemplateDisabledData[$l_document_template_row['isys_document_template__id']] = true;
                }

                // Add to result array.
                $documentTemplateData[$l_document_template_row['isys_document_template__id']] = $this->language->get($l_document_template_row['isys_document_type__title']) .
                    ': ' . $l_document_template_row['isys_document_template__title'];
            }
        }

        if ($documentTypeId) {
            $documentType = isys_factory_cmdb_dialog_dao::get_instance('isys_document_type', $this->database)
                ->get_data_raw($documentTypeId)
                ->get_row_value('isys_document_type__title');

            $noTemplateError = $this->language->get('LC__MODULE__DOCUMENT__DOCUMENT_CREATION__ERROR_NO_TEMPLATES_OF_TYPE', _L($documentType));
        } else {
            $noTemplateError = $this->language->get('LC__MODULE__DOCUMENT__DOCUMENT_CREATION__ERROR_NO_TEMPLATES');
        }

        $this->template
            ->assign('documentTemplateData', $documentTemplateData)
            ->assign('documentTemplateDisabledData', $documentTemplateDisabledData)
            ->assign('documentTemplateID', $documentTemplateId)
            ->assign('noTemplatesError', $noTemplateError)
            ->assign('preselection', $objectId)
            ->display(isys_module_document::getPath() . 'templates/popup/create_document.tpl');

        die();
    }
}
