<div id="document-popup">
    <div class="popup-header-ng">
        <h1>[{isys type="lang" ident="LC__MODULE__DOCUMENT__DOCUMENT__CREATE_DOCUMENT"}]</h1>
        <button type="button" class="btn btn-secondary popup-closer ml-auto" title="[{isys type="lang" ident="LC__POPUP__CLOSE"}]" data-tooltip="1">
            <img class="fr mouse-pointer" alt="" src="[{$dir_images}]axialis/user-interface/window-control-close.svg" />
        </button>
    </div>

    <div class="popup-content">
        [{if count($documentTemplateData)}]
        <table class="contentTable m5">
            <tr>
                <td class="key">[{isys type="f_label" ident="LC__MODULE__DOCUMENT__DOCUMENT__DOCUMENT_TEMPLATE_TITLE" name="C__DOCUMENT__TITLE"}]</td>
                <td class="value">[{isys type="f_text" name="C__DOCUMENT__TITLE"}]</td>
            </tr>
            <tr>
                <td class="key">[{isys type="f_label" ident="LC__MODULE__DOCUMENT__DOCUMENT__DOCUMENT_TEMPLATE" name="C__DOCUMENT__TEMPLATE"}]</td>
                <td class="value">[{isys type="f_dialog"
                    name="C__DOCUMENT__TEMPLATE"
                    id="C__DOCUMENT__TEMPLATE"
                    p_arData=$documentTemplateData
                    p_arDisabled=$documentTemplateDisabledData
                    p_bInfoIconSpacer=1
                    p_strSelectedID=$documentTemplateID
                    chosen=true
                    p_bDbFieldNN=true
                    emptyMessage="LC__MODULE__DOCUMENT__DOCUMENT__TEMPLATE_NOT_FOUND"}]
                </td>
            </tr>
            [{if count($documentTemplateDisabledData)}]
            <tr>
                <td class="key"></td>
                <td class="value">
                    <p class="ml20 m10 p5 box-yellow">
                        <img src="[{$dir_images}]axialis/basic/warning.svg" class="mr5 vam">
                        <span class="vam">
                                <strong>[{isys type="lang" ident="LC__MODULE__DOCUMENT__DOCUMENT_TEMPLATE__TEMPLATES_WITHOUT_CHAPTERS"}]</strong>
                            </span>
                    </p>
                </td>
            </tr>
            [{/if}]
            <tr>
                <td class="key">[{isys type="f_label" ident="LC__POPUP__BROWSER__UI_OBJ_SELECTION" name="LC__POPUP__BROWSER__UI_OBJ_SELECTION"}]</td>
                <td class="value">
                    [{if $preselection}]
                    [{isys type="f_popup" name="C__DOCUMENT__OBJECT" p_strPopupType="browser_object_ng" p_strSelectedID=$preselection catFilter="C__CATG__DOCUMENT"}]
                    [{else}]
                    [{isys type="f_popup" name="C__DOCUMENT__OBJECT" multiselection=1 p_strPopupType="browser_object_ng" catFilter="C__CATG__DOCUMENT"}]
                    [{/if}]
                </td>
            </tr>
        </table>

        <div id="custom-fields"></div>

        <table class="contentTable m5">
            <tr>
                <td class="key vat">[{isys type="f_label" ident="LC__MODULE__DOCUMENT__DOCUMENT__DESCRIPTION" name="C__DOCUMENT__DESCRIPTION"}]</td>
                <td class="value">
                    [{isys
                    type="f_wysiwyg"
                    name="C__DOCUMENT__DESCRIPTION"
                    id="C__DOCUMENT__DESCRIPTION"
                    forceUsage=true
                    p_strStyle="width:250px;"}]
                </td>
            </tr>
        </table>
        [{else}]
        <div class="box-red m5 p5">[{$noTemplatesError}]</div>
        [{/if}]
    </div>

    <div class="popup-footer-ng">
        [{if count($documentTemplateData)}]
        <button type="button" class="btn mr5" id="saveChapter">
            <img src="[{$dir_images}]axialis/basic/symbol-add.svg"><span>[{isys type="lang" ident="LC__CMDB__OBJECT_BROWSER__SCRIPT__ADD"}]</span>
        </button>
        [{/if}]

        <button type="button" class="btn popup-closer">
            <img src="[{$dir_images}]axialis/basic/symbol-cancel.svg"><span>[{isys type="lang" ident="LC__UNIVERSAL__BUTTON_CANCEL"}]</span>
        </button>
    </div>
</div>

<style type="text/css">
    #document-popup td.key {
        width: 150px;
    }
</style>

<script type="text/javascript">
    (function () {
        'use strict';

        const $template = $('C__DOCUMENT__TEMPLATE');
        const $customFields = $('custom-fields');
        const $save_button = $('saveChapter');

        $$('.popup-closer').invoke('on', 'click', function () {
            popup_close($('popup_commentary'));
        });

        if (!$template && $save_button) {
            $save_button.disable();
        }

        [{if count($documentTemplateData) > 0}]

        // Add the chosen plugins.
        $('document-popup').select('select.chosen-select').each(function (element) {
            new Chosen(element, {search_contains: true});
        });

        idoit.Require
            .addModule('document.customFields', '[{isys_module_document::getWwwPath()}]js/customFields.js');

        // @see  DOKU-354  Implement logic to load 'custom fields'.
        idoit.Require.require(['document.customFields'], function () {
            $template.on('change', function () {
                new Ajax.Request(window.www_dir + 'document/ajax/loadTemplateFields', {
                    method:     'post',
                    parameters: {
                        templateId: $template.getValue()
                    },
                    onComplete: function (xhr) {
                        if (!is_json_response(xhr, true)) {
                            return;
                        }

                        let i;
                        const json = xhr.responseJSON.data;
                        const $table = new Element('table', {className: 'contentTable m5'})

                        for (i in json) {
                            if (!json.hasOwnProperty(i)) {
                                continue;
                            }

                            $table.insert(new Element('tr')
                                .update(new Element('td', {className: 'key'}).update(i))
                                .insert(new Element('td', {className: 'value'}).update(json[i])))
                        }

                        $customFields
                            .removeClassName('border-top border-bottom')
                            .update();

                        if ($table.childElementCount) {
                            $customFields
                                .addClassName('border-top border-bottom')
                                .insert($table);
                        }
                    }
                });
            });

            $template.simulate('change');
        });

        if ($save_button) {
            $save_button.on('click', function () {
                if ($template.getValue() > 0) {
                    $save_button
                        .down('img').addClassName('animation-rotate').writeAttribute('src', '[{$dir_images}]axialis/user-interface/loading.svg')
                        .next('span').update('[{isys type="lang" ident="LC__UNIVERSAL__LOADING"}]');

                    // @see  DOKU-354  Combine 'custom fields' with the other parameters.
                    const parameters = Object.extend({
                        documentTitle:      $F('C__DOCUMENT__TITLE'),
                        documentTemplateID: $template.getValue(),
                        description:        $F('C__DOCUMENT__DESCRIPTION'),
                        object:             $F('C__DOCUMENT__OBJECT__HIDDEN'),
                    }, Form.serialize($customFields, {hash:true}) || { });

                    new Ajax.Request('?[{$smarty.const.C__GET__MODULE_ID}]=[{$smarty.const.C__MODULE__DOCUMENT}]&ajax=1&call=document&method=createDocument', {
                        method:     'post',
                        parameters: parameters,
                        onComplete: function (transport) {
                            if (transport.responseText.blank()) {
                                window.location.reload(true);
                            } else {
                                $save_button
                                    .down('img').removeClassName('animation-rotate').writeAttribute('src', '[{$dir_images}]axialis/basic/symbol-add.svg')
                                    .next('span').update('[{isys type="lang" ident="LC__CMDB__OBJECT_BROWSER__SCRIPT__ADD"}]');

                                idoit.Notify.error("[{isys type="lang" ident="LC__MODULE__DOCUMENT__DOCUMENT_CREATION__ERROR_WHILE_COMPILE"}]")
                            }
                        }
                    });
                } else {
                    idoit.Notify.error('[{isys type="lang" ident="LC__MODULE__DOCUMENT__DOCUMENT_CREATION__SET_OBJECT_AND_TEMPLATE"}]');
                }
            });
        }
        [{/if}]
    })();
</script>
