<?php

/**
 * i-doit
 *
 * API model
 *
 * @package    i-doit
 * @subpackage API
 * @author     Selcuk Kekec <skekec@i-doit.de>
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */
class isys_api_model_document_documents extends isys_api_model_document implements isys_api_model_interface
{
    /**
     * Mode-Constants
     */
    const CL__MANUAL__UPDATE = 'update';
    const CL__MANUAL__CREATE = 'create';
    const CL__MANUAL__DELETE = 'delete';
    const CL__MANUAL__READ   = 'read';

	/**
	 * Possible options and their parameters.
	 * @var  array
	 */
	protected $m_options = array(
		'read' => array(C__CMDB__GET__OBJECT, C__DOCUMENT__GET__DOCUMENT_ID)
	);

	/**
	 * Validation.
	 * @var  array
	 */
	protected $m_validation = array(
		'read' => array(),
		'create' => array(),
		'update' => array(),
		'delete' => array()
	);

    /**
     * Data formatting used in format methods.
     * @var  array
     */
	protected $m_mapping = array(
		'isys_document__id' => 'id',
		'isys_document__title' => 'title',
		'isys_obj__id' => 'object_id',
		'isys_document_type__title' => 'type',
		'isys_document_template__id' => 'template_id',
		'isys_document_template__title' => 'template_title',
		'iys_document__created' => 'created'
	);

    /**
     * Read category data
     *
     * $p_param structure:
     *     array (
     *         'property'  => 'manufacturer' | array('title', 'manufacturer),
     *         'category'  => 'C__CATG__CPU'
     *     )
     *
     * @param array $p_params
     * @return array
     */
    public function read($p_params)
    {
        return $this->document_routine($p_params, self::CL__MANUAL__READ);
    } // function


    /**
     * Get the document dao
     *
     * @global  isys_component_database  $g_comp_database
     * @author  Selcuk Kekec <skekec@i-doit.com>
     * @return isys_document_dao
     */
    private function get_document_dao()
    {
        global $g_comp_database;

	    return isys_factory::get_instance('isys_document_dao', $g_comp_database);
    } // function

	/**
	 * @param  isys_cmdb_dao  $p_dao
	 */
	public function __construct(isys_cmdb_dao &$p_dao)
    {
        $this->m_dao = $p_dao;

        parent::__construct();
    } // function


    /**
     * Create Document-Entry.
     *
     * @param   $p_params
     * @return  null
     * @author  Selcuk Kekec <skekec@i-doit.com>
     */
    public function create($p_params)
    {
        return null;
    } // function


    /**
     * Read/Delete document
     *
     * @param   array   $p_params
     * @param   string  $p_mode
     * @return  boolean
     * @throws  isys_exception_api
     * @author  Selcuk Kekec <skekec@i-doit.com>
     */
    public function document_routine($p_params, $p_mode = self::CL__MANUAL__CREATE)
    {
        // Retrieve Category-DAO.
        $l_document_dao = $this->get_document_dao();
        $l_return = array();

        if ($p_mode == self::CL__MANUAL__READ)
        {
            $l_result = array();
            if ((isset($p_params[C__DOCUMENT__GET__DOCUMENT_ID]) && !empty($p_params[C__DOCUMENT__GET__DOCUMENT_ID])) || (isset($p_params[C__CMDB__GET__OBJECT]) && !empty($p_params[C__CMDB__GET__OBJECT])))
            {
                $l_documentIDs = array();

                if (isset($p_params[C__DOCUMENT__GET__DOCUMENT_ID]))
                {
                    if (!is_array($p_params[C__DOCUMENT__GET__DOCUMENT_ID]))
                    {
                        $l_documentIDs[] = $p_params[C__DOCUMENT__GET__DOCUMENT_ID];
                    }
                    else
                    {
                        $l_documentIDs = $p_params[C__DOCUMENT__GET__DOCUMENT_ID];
                    } // if

                    $l_dao_res = $l_document_dao->get_data(NULL, NULL, "AND isys_document__id IN(" . implode($l_documentIDs) . ")");
                }
                else if (isset($p_params[C__CMDB__GET__OBJECT]))
                {
                    $l_objectIDs = array();
                    if (!is_array($p_params[C__CMDB__GET__OBJECT]))
                    {
                        $l_objectIDs[] = $p_params[C__CMDB__GET__OBJECT];
                    }
                    else
                    {
                        $l_objectIDs = $p_params[C__CMDB__GET__OBJECT];
                    }

                    $l_dao_res = $l_document_dao->get_data(NULL, NULL, "AND isys_obj__id IN(" . implode($l_objectIDs) . ")");
                }

                if (isset($l_dao_res) && $l_dao_res)
                {
                    if ($l_dao_res->count())
                    {
                        while ($l_row = $l_dao_res->get_row())
                        {
                            $l_return[] = $this->format_by_mapping($this->m_mapping, $l_row);
                            $l_models   = $l_document_dao->load_models_for_document($l_row['isys_document__id']);
                            $l_export   = new isys_document_export_html(array());
                            $l_export->set_models($l_models)
                                     ->set_title($l_row['isys_document__title']);

                            $l_return[count($l_return) - 1]['text'] = $l_export->export();
                        }
                    }

                    return $l_return;
                }
                else
                {
                    throw new isys_exception_api("Unable to build the query with given parameters.");
                }
            }
            else
            {
                throw new isys_exception_api("Please define a valid value for key '" . C__DOCUMENT__GET__DOCUMENT_ID . "' or '" . C__CMDB__GET__OBJECT . "'.");
            }
        }
        else if ($p_mode == self::CL__MANUAL__DELETE)
        {
            if (isset($p_params[C__DOCUMENT__GET__DOCUMENT_ID]) && !empty($p_params[C__DOCUMENT__GET__DOCUMENT_ID]))
            {
                if ($l_document_dao->deleteDocument($p_params[C__DOCUMENT__GET__DOCUMENT_ID]))
                {
                    return array(
                        'message' => "Document successfully deleted.",
                        'success' => true,
                    );
                }
                else
                {
                    return array(
                        'message' => "Error while deleting document",
                        'success' => true,
                    );
                }
            }
            else
            {
                throw new isys_exception_api("Please define a valid value fo key '" . C__DOCUMENT__GET__DOCUMENT_ID . "'.");
            } // if
        } // if

        return array('success' => false);
    } // function


    /**
     * Update document Entry.
     *
     * @param   $p_params
     * @return  null
     * @author  Selcuk Kekec <skekec@i-doit.com>
     */
    public function update($p_params)
    {
        return null;
    } // function


    /**
     * Delete Dialog+ Entry
     *
     * @param   $p_params
     * @return  null
     * @author  Selcuk Kekec <skekec@i-doit.com>
     */
    public function delete($p_params)
    {
        return $this->document_routine($p_params, self::CL__MANUAL__DELETE);
    } // function
} // class
