<?php

/**
 * i-doit
 *
 * Super compiler model
 *
 * @package     i-doit
 * @subpackage  Modules
 * @author      Selcuk Kekec <skekec@i-doit.com>
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @version     1.0.0
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       i-doit 1.4.0
 */
abstract class isys_document_compiler_model
{
	/**
	 * Title of the model
	 * @var  string
	 */
	protected $m_title;

	/**
	 * Options for this model.
	 * @var  array
	 */
	protected $m_options = array();


	/**
	 * Get title.
	 *
	 * @return  string
	 */
	public function get_title ()
	{
		return $this->m_title;
	} // function


	/**
	 * Get options.
	 *
	 * @return  array
	 */
	public function get_options ()
	{
		return $this->m_options;
	} // function


	/**
	 * Set title.
	 *
	 * @param   string  $p_title
	 * @return  $this
	 */
	public function set_title ($p_title)
	{
		$this->m_title = $p_title;

		return $this;
	} // function


	/**
	 * Constructor.
	 *
	 * @param  array  $p_options
	 */
	public function __construct (array $p_options = array())
	{
		$this->m_options = $p_options;
	} // function
} // class

