[{isys_group name="tom.popup.placeholder"}]
    <div id="document-popup">
        <div class="popup-header-ng">
            <h1>[{isys type="lang" ident="LC__MODULE__DOCUMENT__POPUP_P__IMAGES"}]</h1>
            <button type="button" class="btn btn-secondary popup-closer ml-auto" title="[{isys type="lang" ident="LC__POPUP__CLOSE"}]" data-tooltip="1">
                <img class="fr mouse-pointer" alt="" src="[{$dir_images}]axialis/user-interface/window-control-close.svg" />
            </button>
        </div>

        <div id="document-popup-images" class="popup-content">
	        <ul class="m0 gradient browser-tabs" id="document-popup-images-tabs">
		        <li><a href="#mainobject">[{isys type="lang" ident="LC__MODULE__DOCUMENT__POPUP_P__MAINOBJECT__HEADER"}]</a></li>
		        <li><a href="#externablobject">[{isys type="lang" ident="LC__MODULE__DOCUMENT__POPUP_P__EXTERNALOBJECT__HEADER"}]</a></li>
	        </ul>

	        <div id="mainobject" class="p10">
		        <table style="width:100%;">
			        <tr>
				        <td>
					        <label class="mouse-pointer">
						        <input type="radio" name="image-option-selection" value="first-image" /><span class="ml5">[{isys type="lang" ident="LC__MODULE__DOCUMENT__POPUP_P__IMAGES_FIRST_IMAGE"}]</span><br />
						        <img src="[{$image_url}]popup-images-first-image.png" />
					        </label>
				        </td>
				        <td>
					        <label class="mouse-pointer">
						        <input type="radio" name="image-option-selection" value="all-images" /><span class="ml5">[{isys type="lang" ident="LC__MODULE__DOCUMENT__POPUP_P__IMAGES_ALL_IMAGES"}]</span><br />
						        <img src="[{$image_url}]popup-images-all-images.png" />
					        </label>
				        </td>
				        <td>
					        <label class="mouse-pointer">
						        <input type="radio" name="image-option-selection" value="last-image" /><span class="ml5">[{isys type="lang" ident="LC__MODULE__DOCUMENT__POPUP_P__IMAGES_LAST_IMAGE"}]</span><br />
						        <img src="[{$image_url}]popup-images-last-image.png" />
					        </label>
				        </td>
			        </tr>
		        </table>
	        </div>

	        <div id="externablobject">
		        <div class="p10">
			        [{isys type="f_label" ident="LC__MODULE__DOCUMENT__POPUP_P__IMAGES_OBJ_SELECTION" name="document_popup_object_browser__VIEW"}]

			        [{isys type="f_popup"
			        name="document_popup_object_browser"
			        p_strPopupType="browser_object_ng"
			        secondSelection=false
			        catFilter="C__CATG__IMAGES"
			        callback_accept="idoit.callbackManager.triggerCallback('document-popup-objectbrowser-change');"
			        callback_detach="idoit.callbackManager.triggerCallback('document-popup-objectbrowser-change');"}]
		        </div>

		        <div id="document-popup-images-gallery" style="height:365px; overflow-y:auto;"></div>
	        </div>
        </div>

        <div class="popup-footer-ng">
            <button type="button" class="btn mr5" id="document-popup-save-button">
                <img src="[{$dir_images}]axialis/basic/symbol-ok.svg"><span>[{isys type="lang" ident="LC__CMDB__OBJECT_BROWSER__SCRIPT__ADD"}]</span>
            </button>
            <button type="button" class="btn popup-closer">
                <img src="[{$dir_images}]axialis/basic/symbol-cancel.svg"><span>[{isys type="lang" ident="LC__UNIVERSAL__BUTTON_CANCEL"}]</span>
            </button>
        </div>
    </div>

    <script type="text/javascript">
        (function () {
            "use strict";

            var widget = window.currently_selected_document_widget,
	            widget_data = widget.data,
	            editor = widget.editor,
                $content = $('document-popup-images'),
                $gallery = $('document-popup-images-gallery'),
	            $obj_browser = $('document_popup_object_browser__HIDDEN'),
	            $tabs = $('document-popup-images-tabs');

	        if ($tabs) {
		        new Tabs($tabs, {
			        wrapperClass: 'browser-tabs',
			        contentClass: 'browser-tab-content',
			        tabClass: 'text-shadow mouse-pointer'
		        });
	        }

            $$('.popup-closer').invoke('on', 'click', function () {
                // If the user closes the popup, we want to destroy the widget!
                if (widget.data.data && widget.data.data.hasOwnProperty('id') && !widget.data.data.id) {
                    widget.remove_and_set_focus();
                }

                popup_close($('popup_placeholder'));

                window.currentEditor.focus();
            });

	        // Reload images
	        idoit.callbackManager.registerCallback('document-popup-objectbrowser-change', function () {
		        var object_id = parseInt($obj_browser.getValue()),
			        object_name = $('document_popup_object_browser__VIEW').getValue();

		        if (object_id > 0) {
		            var $images = $gallery.select('.gallery-item');

			        // If we are about to load new images, we fade away the old ones.
			        if ($images.length > 0) {
				        $images.invoke('fade');
			        }

			        new Ajax.Request('[{$ajax_url}]&load=1', {
				        parameters: {
					        '[{$smarty.const.C__CMDB__GET__OBJECT}]': object_id
				        },
				        method: "post",
				        onSuccess: function (transport) {
					        var json = transport.responseJSON, i;

					        if (json.success && json.data) {
						        if (json.data.count > 0) {
							        for (i in json.data.images) {
								        if (json.data.images.hasOwnProperty(i)) {
									        json.data.images[i].object_id = object_id;
									        json.data.images[i].object_name = object_name;

									        $gallery.insert(render_image(json.data.images[i]));
								        }
							        }
						        } else {
							        idoit.Notify.info('[{isys type="lang" ident="LC__MODULE__DOCUMENT__POPUP_P__IMAGES_NONE_FOUND"}]');
						        }
					        } else {
						        idoit.Notify.error(json.message || '[{isys type="lang" ident="LC__MODULE__DOCUMENT__POPUP_P__IMAGES_LOADING_ERROR"}]', {sticky:true});
					        }
				        }
			        });
		        }
	        });

	        $gallery.on('click', '.gallery-item', function (ev) {
		        ev.findElement('.gallery-item').toggleClassName('selected');
	        });

            // And add some "accept" logic.
            $('document-popup-save-button').on('click', function (ev) {
                var $selection = $gallery.select('.gallery-item.selected'),
	                data;


	            if ($tabs.down('.active').readAttribute('href') == '#mainobject') {
		            widget.setData({
			            type: 'image',
			            data: {
				            image_option: $content.down('input[type="radio"]:checked').getValue(),
				            image_id: null,
				            image_filename: null,
				            object_id: null,
				            object_name: null
			            }
		            });
	            } else {
		            if ($selection.length) {
			            $selection.each(function ($img, index) {
				            var element;

				            // Because one widget is already existing, we skip the creation of the first placeholder.
				            if (index === 0) {
					            data = {
						            type: 'image',
						            data: {
							            image_option: null,
							            image_id: $img.readAttribute('data-image-id'),
							            image_filename: $img.readAttribute('data-image-filename'),
							            object_id: $img.readAttribute('data-object-id'),
							            object_name: $img.readAttribute('data-object-name')
						            }
					            };
				            } else {
					            // We create a "widget-like" element, add it to the editor and initialize it as widget.
					            element = editor.document.createElement('span', {
							            attributes: {
								            "class": "document-wysiwyg-placeholder",
								            "data-widget-type": "images",
								            "data-json": JSON.stringify({
									            type: 'image',
									            data: {
										            image_option: null,
										            image_id: $img.readAttribute('data-image-id'),
										            image_filename: $img.readAttribute('data-image-filename'),
										            object_id: $img.readAttribute('data-object-id'),
										            object_name: $img.readAttribute('data-object-name')
									            }
								            })
							            }
						            }
					            );

					            // We need to add the new element after the widget-parent, because its
					            element.insertAfter(widget.element.getParent());

					            editor.widgets.initOn(element, 'images');
				            }
			            });

			            widget.setData(data);
		            } else {
			            widget.remove_and_set_focus();
		            }
	            }

                popup_close($('popup_placeholder'));

                window.currentEditor.focus();
            });

            function render_image (image) {
	            var $thumb = new Element('div', {className:'gallery-item', 'data-image-id': image.image_id, 'data-image-filename':image.image_filename, 'data-object-name':image.object_name, 'data-object-id': image.object_id}),
                    $img = new Element('img', {className:'thumb'}).hide(),
                    $loader = new Element('img', {src:'[{$dir_images}]axialis/user-interface/loading.svg', className:'loader animation-rotate'});

                $img.on('load', function (ev) {
                    var $img = ev.findElement('img'),
	                    $thumb = $img.up('.gallery-item');

                    ev.findElement('img').setStyle({margin: ((200 - $img.getHeight()) / 2) + 'px ' + ((200 - $img.getWidth()) / 2) + 'px'}).appear();

                    $img.next('.loader').fade();

	                $thumb.writeAttribute('title', $thumb.readAttribute('data-image-filename') + ' (' + $img.naturalWidth + 'x' + $img.naturalHeight + ')');
                });

                $img.writeAttribute('src', '[{$ajax_url}]&[{$smarty.const.C__GET__FILE__ID}]=' + image.image_id);

	            // This is used for preselecting images.
	            if (widget_data.data.hasOwnProperty('image_id') && widget_data.data.image_id > 0) {
		            if (widget_data.data.image_id == image.image_id) {
			            $thumb.addClassName('selected');
		            }
	            }

                return $thumb.update($img).insert($loader);
            }

	        // Finally handle the preselection:
	        if (widget_data.hasOwnProperty('data') && widget_data.data.hasOwnProperty('image_id')) {
		        if (widget_data.data.hasOwnProperty('image_option') && widget_data.data.image_option !== null) {
			        $content.down('input[value="' + widget_data.data.image_option + '"]').setValue(1);
		        } else {
			        $tabs.down('a[href="#externablobject"]').simulate('click');

			        // First we set the object browser values.
			        $obj_browser.setValue(widget_data.data.object_id);
			        $('document_popup_object_browser__VIEW').setValue(widget_data.data.object_name);

			        // And then simply trigger the "change" callback.
			        idoit.callbackManager.triggerCallback('document-popup-objectbrowser-change');
		        }
	        }
        })();
    </script>

	<style type="text/css">
		#document-popup-images div.gallery-item {
			position: relative;
			float: left;
			border: 1px solid #aaa;
			margin: 5px;
			width: 200px;
			height: 200px;
			background: #fff url('[{$dir_images}]pattern3.png');
			overflow: hidden;
			cursor: pointer;
		}

		#document-popup-images div.gallery-item.selected {
			border: 3px solid #a00;
			margin: 3px;
		}

		#document-popup-images img.loader {
			position: absolute;
			left: 92px;
			top: 92px;
		}

		#document-popup-images img.thumb {
			max-width: 100%;
			max-height: 100%;
		}
	</style>
[{/isys_group}]
