<?php

/**
 * @package     i-doit
 * @subpackage  Modules
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_document_format_html extends isys_document_format_text
{
    /**
     * @return string
     */
    public function getHeader(): string
    {
        return $this->replace_variables((string)$this->m_options['header']);
    }

    /**
     * Add Chapter heading.
     *
     * @param string $title
     * @param string $pos
     * @param int    $level
     *
     * @return $this
     */
    public function addHeadline(string $title, string $pos, int $level): self
    {
        $fontColor = '#000000';
        $fontColorKey = 'general.h' . $level . '.color';

        if (isset($this->m_options[$fontColorKey])) {
            $fontColor = $this->m_options[$fontColorKey];
        }

        $this->m_content .= '<h' . $level . ' style="color:' . $fontColor . ';">' . $pos . ' ' . $title . '</h' . $level . '>';

        return $this;
    }

    /**
     * Add Chapter content.
     *
     * @param string $text
     *
     * @return $this
     */
    public function addContent(string $text): self
    {
        $this->m_content .= '<div class="standard">' . $this->replace_variables($text) . '</div>';

        return $this;
    }

    /**
     * @return string
     */
    public function getFooter(): string
    {
        return $this->replace_variables((string)$this->m_options['footer']);
    }

    /**
     * Retrieves the format option definition for HTML.
     *
     * @return array
     */
    public function getFormatOptionDefinition(): array
    {
        return [];
    }

    /**
     * @param string $text
     *
     * @return string
     */
    protected function replace_variables(string $text): string
    {
        $replacements = [
            '%%CURRENT_PAGE%%'     => '',
            '%%TOTAL_PAGES%%'      => '',
            '%%REVISION_ID%%'      => $this->m_options['revisionId'],
            '%%REVISION_COMMENT%%' => $this->m_options['revisionComment'],
        ];

        return strtr($text, $replacements);
    }
}
