/**
 * i-doit CKEditor plugin
 *
 * @author Selcuk Kekec <skekec@synetics.de>
 * @author Leonard Fischer <lfischer@synetics.de>
 */

'use strict';

(function () {
    var placeholderClass = 'document-wysiwyg-placeholder';
    
    CKEDITOR.plugins.add('idoit', {
        requires: 'widget',
        icons:    'application_form_add,calendar_add,layout_add,report_add,image_add,floorplan_add,page_split',
        lang:     ['en', 'de'],
        
        /**
         * Initialize the plugin.
         * This is called for every single instance of CKEditor
         */
        beforeInit: function () {
            // Here we can do some initialization work if neeed.
            if (!$('popup_placeholder')) {
                $('wrapper').insert(new Element('div', {id: 'popup_placeholder', className: 'popup', style: 'display:none;'}))
            }
        },
        
        /**
         * Initialize method will register all buttons and widgets.
         *
         * @param editor
         */
        init: function (editor) {
            var lang                              = editor.lang.idoit.placeholder,
                object_master_widget_definition   = {
                    widget_name: lang.mainObjectPlaceholder,
                    widget_type: 'masterObject',
                    pathName:    'i-doit ' + lang.placeholder,
                    template:    '<span class="' + placeholderClass + '" data-widget-type="masterObject" data-json="{}">' + lang.mainObjectPlaceholder + '</span>',
                    inline:      true,
                    defaults:    {
                        widget_type: 'masterObject',
                        type:        null, // 'category' or 'property'
                        data:        {
                            catg:      '',
                            catg_name: '',
                            catg_type: '', // 'g' or 's'
                            prop:      '',
                            objID:     null // NULL means "master"
                        }
                    },
                
                    remove_and_set_focus: function () {
                        this.editor.widgets.del(this);
                    },
                
                    data: function () {
                        // This is used to display the widget in "WYSIWYG" view.
                        this.element.setHtml(this.render_html());
                    },
                
                    downcast: function () {
                        // This is used to display the widget in "sourcecode" view.
                        return new CKEDITOR.htmlParser.text(this.render_html());
                    },
                
                    edit: function () {
                        window.currently_selected_document_widget = this;
                        window.currentEditor = editor;
                        get_popup('document_placeholder_object', 'editMode=1&destination=' + editor.type, 910, 470, {data: Object.toJSON(this.data)}, 'popup_placeholder');
                    },
                
                    init: function () {
                        var json_data = this.element.$.getAttribute('data-json');
                    
                        // Here we read the attributes from the element and set our data accordingly.
                        if (json_data !== null) {
                            json_data = JSON.parse(json_data.replace(/'/g, '"'));
                            Object.extend(this.data, json_data);
                        }
                    
                        this.data.widget_type = this.widget_type;
                    },
                
                    render_html: function () {
                        var display_name   = '?',
                            data_attribute = this.data;
                    
                        if (this.data.type == 'category') {
                            display_name = this.data.data.catgName;
                        } else if (this.data.type == 'property') {
                            display_name = this.data.data.propName;
                        }
                    
                        // This gets implemented by CKE.
                        delete data_attribute.classes;
                    
                        return new Element('span', {className: placeholderClass, 'data-widget-type': this.data.widget_type, 'data-json': Object.toJSON(data_attribute).replace(/"/g, "'")})
                            .update(this.widget_name + ' (' + display_name + ')')
                            .outerHTML
                    }
                },
                object_external_widget_definition = Object.clone(object_master_widget_definition),
                report_widget_definition          = Object.clone(object_master_widget_definition),
                template_widget_definition        = Object.clone(object_master_widget_definition),
                images_widget_definition          = Object.clone(object_master_widget_definition),
                floorplan_widget_definition       = Object.clone(object_master_widget_definition),
                pagebreak_widget_definition       = Object.clone(object_master_widget_definition);
            
            // Configure the "object_external" widget definition.
            object_external_widget_definition.widget_name = lang.externalObjectPlaceholder;
            object_external_widget_definition.widget_type = 'externalObject';
            object_external_widget_definition.template = '<span class="' + placeholderClass + '" data-widget-type="externalObject" data-json="{}">' + lang.externalObjectPlaceholder + '</span>';
            object_external_widget_definition.defaults = {
                widget_type: 'externalObject',
                type:        null,
                data:        {
                    catg:      '',
                    catg_name: '',
                    catg_type: '',
                    prop:      '',
                    objID:     null
                }
            };
            
            object_external_widget_definition.edit = function () {
                window.currently_selected_document_widget = this;
                window.currentEditor = editor;
                get_popup('document_placeholder_external_object', 'editMode=1&destination=' + editor.name, 910, 510, {data: Object.toJSON(this.data)}, 'popup_placeholder');
            };
            
            object_external_widget_definition.render_html = function () {
                var display_name   = '?',
                    data_attribute = Object.clone(this.data);
                
                if (this.data.type == 'category') {
                    display_name = data_attribute.data.catgName;
                } else if (this.data.type == 'property') {
                    display_name = data_attribute.data.propName;
                }
                
                // This gets implemented by CKE.
                delete data_attribute.classes;
                
                return new Element('span', {className: placeholderClass, 'data-widget-type': data_attribute.widget_type, 'data-json': Object.toJSON(data_attribute).replace(/"/g, "'")})
                    .update((data_attribute.data.objName || 'Object') + ' (' + display_name + ')')
                    .outerHTML;
            };
            
            // Configure the "report" widget definition.
            report_widget_definition.widget_name = lang.reportPlaceholder;
            report_widget_definition.widget_type = 'report';
            report_widget_definition.template = '<span class="' +
                                                placeholderClass +
                                                '" data-widget-type="report" data-json="{}">' +
                                                lang.externalObjectPlaceholder +
                                                '</span>';
            report_widget_definition.defaults = {
                widget_type: 'report',
                type:        'report',
                data:        {
                    id:   null,
                    name: ''
                }
            };
            
            report_widget_definition.edit = function () {
                window.currently_selected_document_widget = this;
                window.currentEditor = editor;
                get_popup('document_placeholder_report', 'editMode=1&destination=' + editor.name, 600, 430, {data: Object.toJSON(this.data)}, 'popup_placeholder');
            };
            
            report_widget_definition.render_html = function () {
                var data_attribute = Object.clone(this.data);
                
                // This gets implemented by CKE.
                delete data_attribute.classes;
                
                return new Element('span', {className: placeholderClass, 'data-widget-type': data_attribute.widget_type, 'data-json': Object.toJSON(data_attribute).replace(/"/g, "'")})
                    .update(this.widget_name + ' "' + data_attribute.data.name + '"')
                    .outerHTML;
            };
            
            // Configure the "template" widget definition.
            template_widget_definition.widget_name = lang.templatePlaceholder;
            template_widget_definition.widget_type = 'template';
            template_widget_definition.template = '<span class="' + placeholderClass + '" data-widget-type="template" data-json="{}">' + lang.externalObjectPlaceholder + '</span>';
            template_widget_definition.defaults = {
                widget_type: 'template',
                type:        'templateVar',
                data:        {
                    key:  '',
                    name: ''
                }
            };
            
            template_widget_definition.edit = function () {
                window.currently_selected_document_widget = this;
                window.currentEditor = editor;
                get_popup('document_placeholder_template_vars', 'editMode=1&destination=' + editor.name, '50%', '40%', {data: Object.toJSON(this.data)}, 'popup_placeholder', 530, 300, 750, 330);
            };
            
            template_widget_definition.render_html = function () {
                var data_attribute = Object.clone(this.data);
                
                // This gets implemented by CKE.
                delete data_attribute.classes;
                
                return new Element('span', {className: placeholderClass, 'data-widget-type': data_attribute.widget_type, 'data-json': Object.toJSON(data_attribute).replace(/"/g, "'")})
                    .update(this.widget_name + ' "' + data_attribute.data.name + '"')
                    .outerHTML;
            };
            
            // Configure the "images" widget definition.
            images_widget_definition.widget_name = lang.imagesPlaceholder;
            images_widget_definition.widget_type = 'images';
            images_widget_definition.template = '<span class="' + placeholderClass + '" data-widget-type="images" data-json="{}">' + lang.imagesPlaceholder + '</span>';
            images_widget_definition.defaults = {
                widget_type: 'images',
                type:        'image',
                data:        {
                    id:   null,
                    name: ''
                }
            };
            
            images_widget_definition.edit = function () {
                window.currently_selected_document_widget = this;
                window.currentEditor = editor;
                get_popup('document_placeholder_images', 'editMode=1&destination=' + editor.name, 870, 510, {data: Object.toJSON(this.data)}, 'popup_placeholder');
            };
            
            images_widget_definition.render_html = function () {
                var data_attribute     = Object.clone(this.data),
                    placeholder_string = this.widget_name + ' (' + data_attribute.data.object_name + ' "' + data_attribute.data.image_filename + '")';
                
                // This gets implemented by CKE.
                delete data_attribute.classes;
                
                if (data_attribute.data.hasOwnProperty('image_option') && data_attribute.data.image_option !== null) {
                    placeholder_string = this.widget_name + ' (' + lang.mainObjectPlaceholder + ' "' + lang[data_attribute.data.image_option] + '")';
                }
                
                return new Element('span', {className: placeholderClass, 'data-widget-type': data_attribute.widget_type, 'data-json': JSON.stringify(data_attribute)})
                    .update(placeholder_string)
                    .outerHTML;
            };
            
            // Configure the "floorplan" widget definition.
            floorplan_widget_definition.widget_name = lang.floorplanPlaceholder;
            floorplan_widget_definition.widget_type = 'floorplan';
            floorplan_widget_definition.template = '<span class="' + placeholderClass + '" data-widget-type="floorplan" data-json="{}">' + lang.floorplanPlaceholder + '</span>';
            floorplan_widget_definition.defaults = {
                widget_type: 'floorplan',
                type:        'floorplan',
                data:        {
                    objectId: 0,
                    name:     ''
                }
            };
            
            floorplan_widget_definition.edit = function () {
                window.currently_selected_document_widget = this;
                window.currentEditor = editor;
                get_popup('document_placeholder_floorplan', 'editMode=1&destination=' + editor.name, 400, '80%', {data: Object.toJSON(this.data)}, 'popup_placeholder', 400, 300, 400, 600);
            };
            
            floorplan_widget_definition.render_html = function () {
                var data_attribute = Object.clone(this.data);
                
                // This gets implemented by CKE.
                delete data_attribute.classes;
                
                return new Element('span', {className: placeholderClass, 'data-widget-type': data_attribute.widget_type, 'data-json': JSON.stringify(data_attribute)})
                    .update(this.widget_name + ' (' + data_attribute.data.objectTitle + ')')
                    .outerHTML;
            };
            
            // Add CSS.
            editor.addContentsCss(this.path + 'styles/placeholder.css?' + CKEDITOR.timestamp);
            
            // Now we add the several widgets.
            if (editor.widgets.add) {
                editor.widgets.add('masterObject', object_master_widget_definition);
                editor.widgets.add('externalObject', object_external_widget_definition);
                editor.widgets.add('report', report_widget_definition);
                editor.widgets.add('template', template_widget_definition);
                editor.widgets.add('images', images_widget_definition);
                editor.widgets.add('floorplan', floorplan_widget_definition);
                editor.widgets.add('pageBreak', {
                    widget_name: lang.pageBreakPlaceholder,
                    widget_type: 'pageBreak',
                    editables:   {},
                    pathName:    'i-doit ' + lang.placeholder,
                    template:    '<div class="' + placeholderClass + ' page-breaker" data-widget-type="pageBreak" data-json="{}"><span>' + (lang.pageBreakPlaceholder || 'Page break') + '</span></div>',
                    mask:        true,
                    inline:      false,
                    defaults:    {widget_type: 'pageBreak', type: 'pageBreaker'},
                    
                    remove_and_set_focus: function () {
                        this.editor.widgets.del(this);
                    },
                    
                    data: function () {
                        // This is used to display the widget in "WYSIWYG" view.
                        this.element.setHtml(this.render_html());
                    },
                    
                    downcast: function () {
                        // This is used to display the widget in "sourcecode" view.
                        return new CKEDITOR.htmlParser.text(this.render_html());
                    },
                    
                    upcast: function ($el) {
                        // This is used to display the widget in "WYSIWYG" view.
                        return ($el.hasOwnProperty('attributes') && $el.attributes.hasOwnProperty('data-widget-type') && $el.attributes['data-widget-type'] === 'pageBreak');
                    },
                    
                    edit: Prototype.emptyFunction,
                    
                    init: function () {
                        var json_data = this.element.$.getAttribute('data-json');
                        
                        // Here we read the attributes from the element and set our data accordingly.
                        if (json_data !== null) {
                            json_data = JSON.parse(json_data.replace(/'/g, '"'));
                            Object.extend(this.data, json_data);
                        }
                        
                        this.data.widget_type = this.widget_type;
                    },
                    
                    render_html: function () {
                        return new Element('div', {className: placeholderClass + ' page-breaker', 'data-widget-type': 'pageBreak', 'data-json': '{"type": "pageBreak"}'})
                            .update(new Element('span').update(lang.pageBreakPlaceholder || 'Page break'))
                            .outerHTML;
                    }
                });
            }
            
            // And we add the buttons to the UI.
            if (editor.ui.addButton) {
                editor.ui.addButton('masterObject', {label: lang.mainObjectPlaceholder, command: 'masterObject', toolbar: 'idoit', icon: 'application_form_add'});
                editor.ui.addButton('externalObject', {label: lang.externalObjectPlaceholder, command: 'externalObject', toolbar: 'idoit', icon: 'calendar_add'});
                editor.ui.addButton('report', {label: lang.reportPlaceholder, command: 'report', toolbar: 'idoit', icon: 'report_add'});
                editor.ui.addButton('template', {label: lang.templatePlaceholder, command: 'template', toolbar: 'idoit', icon: 'layout_add'});
                editor.ui.addButton('images', {label: lang.imagesPlaceholder, command: 'images', toolbar: 'idoit', icon: 'image_add'});
                editor.ui.addButton('floorplan', {label: lang.floorplanPlaceholder, command: 'floorplan', toolbar: 'idoit', icon: 'floorplan_add'});
                editor.ui.addButton('pageBreak', {label: lang.pageBreakPlaceholder, command: 'pageBreak', toolbar: 'idoit-secondary', icon: 'page_split'});
            }
        },
        
        /**
         * The After-Init method will find all used widgets in the current CKE instance and translate them back to single widgets.
         *
         * @author  Leonard Fischer <lfischer@synetics.de>
         * @param   editor
         */
        afterInit: function (editor) {
            if (editor.dataProcessor && editor.dataProcessor.dataFilter) {
                editor.dataProcessor.dataFilter.addRules({
                    elements: {
                        'span': function (el) {
                            if (el.attributes && el.attributes.class && new RegExp(placeholderClass).test(el.attributes.class)) {
                                // Adds the widget to the found element.
                                editor.widgets.wrapElement(el, el.attributes['data-widget-type']);
                            }
                            
                            return el;
                        }
                    }
                });
            }
        }
    });
})();


