<?php

namespace idoit\Module\Document\CustomFields\Value;

use DateTime;
use isys_application;
use isys_module_document;
use isys_smarty_plugin_f_popup;

/**
 * i-doit customfield datetime value.
 *
 * @package     document
 * @author      Kevin Mauel <kmauel@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       1.3.0
 */
class DateTimeValue extends AbstractCustomFieldValue
{
    const LABEL = 'LC__MODULE__DOCUMENT__CUSTOM_FIELDS__VALUE__DATETIME';

    /**
     * @inheritdoc
     */
    public function getStringValue()
    {
        if (empty($this->value)) {
            return null;
        }

        return (new DateTime($this->value))->format('Y-m-d H:i:s');
    }

    /**
     * @inheritdoc
     */
    public function getFormattedValue()
    {
        if (empty($this->value)) {
            return '';
        }

        return isys_application::instance()->container->get('locales')->fmt_datetime($this->value);
    }

    /**
     * @inheritdoc
     */
    public function getTemplate($name, $value, $editMode)
    {
        $smartyPlugin = new isys_smarty_plugin_f_popup();
        $template = isys_application::instance()->container->get('template');
        $parameters = [
            'id'             => $name,
            'name'           => $name,
            'p_strValue'     => $value,
            'p_strPopupType' => 'calendar',
            'p_strClass'     => 'input-small',
            'p_strStyle'     => 'width:70%;',
            'p_bEditMode'    => $editMode,
            'p_bTime'        => true
        ];

        if ($editMode) {
            return $smartyPlugin->navigation_edit($template, $parameters);
        }

        return $smartyPlugin->navigation_view($template, $parameters);
    }
}
