[{isys type="f_text" p_bInvisible=true p_bInfoIconSpacer=0 name="template_id" id="template_id" p_bEditMode=1}]

<style type="text/css">
	.even {
		background-color: #f3f3f3;
	}
</style>

<div id="document_creation">
	<table class="contentTable">
		<tr>
			<td class="key">[{isys type="f_label" ident="LC__MODULE__DOCUMENT__DOCUMENT__TYPE" name="C__DOCUMENT__TYPE"}]</td>
			<td class="value">[{isys type="f_dialog" name="C__DOCUMENT__TYPE" p_strTable="isys_document_type" p_bDisabled="1"}]</td>
		</tr>
		[{if ($objID)}]
			<tr>
				<td class="key">[{isys type="f_label" ident="LC__MODULE__DOCUMENT__CONNECTED_OBJECT" name="C__DOCUMENT__ASSIGNED_OBJECT"}]</td>
				<td class="value pl20">[{$assigned_object_url}]</td>
			</tr>
		[{/if}]
		<tr>
			<td class="key">[{isys type="f_label" ident="LC__MODULE__DOCUMENT__DOCUMENT_TEMPLATE" name="C__DOCUMENT__ASSIGNED_OBJECT"}]</td>
			<td class="value pl20">[{$template_url}]</td>
		</tr>
		<tr>
			<td class="key">[{isys type="f_label" ident="LC__CMDB__CATG__DOCUMENT__CREATION_REFRESH_DATE"}]</td>
			<td class="value pl20">[{$creation_date}]</td>
		</tr>

        <!-- DOKU-355 -->
        [{if count($customFields)}]

        <tr>
            <td colspan="2">
                <hr class="mt5 mb5" />
            </td>
        </tr>

        [{foreach $customFields as $name => $html}]

        <tr>
            <td class="key">[{$name}]</td>
            <td class="value">[{$html}]</td>
        </tr>

        [{/foreach}]

        <tr>
            <td colspan="2">
                <hr class="mt5 mb5" />
            </td>
        </tr>

        [{/if}]

		<tr>
			<td class="key">[{isys type="f_label" ident="LC__MODULE__DOCUMENT__DOCUMENT__EXPORT_AS"}]</td>
			<td class="value pl20">
				<a class="btn btn-small mr5" href="[{$export_links.html_download}]">
					<img src="[{$dir_images}]axialis/documents-folders/document-type-code-1.svg"><span>[{isys type="lang" ident="LC__MODULE__DOCUMENT__FORMAT__HTML"}]</span>
				</a>
				<a class="btn btn-small mr5" href="[{$export_links.pdf_download}]">
					<img src="[{$dir_images}]axialis/documents-folders/document-type-pdf.svg"><span>[{isys type="lang" ident="LC__MODULE__DOCUMENT__FORMAT__PDF"}]</span>
				</a>
				<a class="btn btn-small" href="[{$export_links.pdf_inline}]">
					<img src="[{$dir_images}]axialis/documents-folders/document-type-pdf.svg"><span>[{isys type="lang" ident="LC__MODULE__DOCUMENT__FORMAT__PDF"}] [{isys type="lang" ident="LC__MODULE__DOCUMENT__EXPORT_INLINE"}]</span>
				</a>
			</td>
		</tr>
		<tr>
			<td class="key vat">[{isys type="f_label" ident="LC__MODULE__DOCUMENT__DOCUMENT__DESCRIPTION" name="C__DOCUMENT__DESCRIPTION"}]</td>
			<td class="value">[{isys type="f_wysiwyg" name="C__DOCUMENT__DESCRIPTION"}]</td>
		</tr>
	</table>

	<div class="border m10" style="width:50%;">
		<div class="bg-neutral-200 p5">
            <button type="button" id="document-collapsible-toggler" class="btn btn-secondary" title="[{isys type="lang" ident="LC__UNIVERSAL__TOGGLE_VIEW"}]" data-tooltip="1">
                <img src="[{$dir_images}]axialis/user-interface/angle-right-small.svg" alt="" />
            </button>
			<span class="vam">[{isys type="f_label" ident="LC__MODULE__DOCUMENT__DOCUMENT__ALL_REVISIONS" name="C__DOCUMENT__TYPE"}]</span>
		</div>
		<div>
			<table id="revision_table" class="mainTable border-top hide">
				<thead>
				<tr>
					<th>[{isys type="lang" ident="LC__MODULE__DOCUMENT__POPUP_P__TEMPLATE_VAR__CREATION_DATE"}]</th>
					<th>[{isys type="lang" ident="LC__MODULE__DOCUMENT__REVISION_CREATOR"}]</th>
					<th></th>
				</tr>
				</thead>
				<tbody>
				[{foreach from=$revisions item=revision key=indexx}]
					<tr>
						<td>[{$revision.isys_document_revision__created}]</td>
						<td>
							<a href="?objID=[{$revision.isys_cats_person_list__isys_obj__id}]" target="_blank">
								<img src="[{$dir_images}]axialis/user-management/user.svg" class="vam mr5"/> <span class="vam">[{$revision.isys_cats_person_list__first_name}] [{$revision.isys_cats_person_list__last_name}]</span>
							</a>
						</td>
						<td>
							<a class="btn btn-small mr5" href="[{$revision.html_download}]">
								<img src="[{$dir_images}]axialis/documents-folders/document-type-code-1.svg"><span>[{isys type="lang" ident="LC__MODULE__DOCUMENT__FORMAT__HTML"}]</span>
							</a>
							<a class="btn btn-small mr5" href="[{$revision.pdf_download}]">
								<img src="[{$dir_images}]axialis/documents-folders/document-type-pdf.svg"><span>[{isys type="lang" ident="LC__MODULE__DOCUMENT__FORMAT__PDF"}]</span>
							</a>
							<a class="btn btn-small" href="[{$revision.pdf_inline}]">
								<img src="[{$dir_images}]axialis/documents-folders/document-type-pdf.svg"><span>[{isys type="lang" ident="LC__MODULE__DOCUMENT__FORMAT__PDF"}] [{isys type="lang" ident="LC__MODULE__DOCUMENT__EXPORT_INLINE"}]</span>
							</a>
						</td>
					</tr>
				[{/foreach}]
				</tbody>
			</table>
		</div>
	</div>
</div>

<script type="text/javascript">
	(function () {
		"use strict";

		var $regerenate_doc = $('navbar_item_regenerate_document'),
			$toggleButton = $('document-collapsible-toggler');

		if ($regerenate_doc) {
			$regerenate_doc.on('click', function () {
				$regerenate_doc.disable()
                    .down('img').addClassName('animation-rotate').writeAttribute('src', '[{$dir_images}]axialis/user-interface/loading.svg');

				new Ajax.Request('?[{$smarty.const.C__GET__MODULE_ID}]=[{$smarty.const.C__MODULE__DOCUMENT}]&[{$smarty.const.C__GET__AJAX}]=1&[{$smarty.const.C__GET__AJAX_CALL}]=document&method=regenerateDocument', {
					method: 'post',
					parameters: {
						'[{$smarty.const.C__DOCUMENT__GET__DOCUMENT_ID}]': '[{$document_id}]'
					},
					onComplete: function (transport) {
						$regerenate_doc.enable()
                            .down('img').removeClassName('animation-rotate').writeAttribute({src: '[{$dir_images}]axialis/basic/symbol-update.svg'});

						if (transport.responseText.blank()) {
							idoit.Notify.success("[{isys type="lang" ident="LC__MODULE__DOCUMENT__DOCUMENT_CREATION__REGENERATION_SUCCESS"}]");

                            location.reload();
						} else {
							idoit.Notify.error("[{isys type="lang" ident="LC__MODULE__DOCUMENT__DOCUMENT_CREATION__REGENERATION_FAIL"}]");
						}
					}
				});
			})
		}

		if ($toggleButton) {
			$toggleButton.on('click', function () {
				if ($('revision_table').toggleClassName('hide').hasClassName('hide')) {
                    $toggleButton.down('img').writeAttribute('src', window.dir_images + 'axialis/user-interface/angle-right-small.svg');
                } else {
                    $toggleButton.down('img').writeAttribute('src', window.dir_images + 'axialis/user-interface/angle-down-small.svg');
                }
			});
		}
	})();
</script>
