<?php

use idoit\Module\Document\CustomFields\Repository\CustomFieldsRepository;

/**
 * i-doit
 *
 * Document compiler
 *
 * @package     i-doit
 * @subpackage  Modules
 * @author      Selcuk Kekec <skekec@i-doit.com>
 * @version     1.0.0
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       i-doit 1.4.0
 */
class isys_document_compiler_document extends isys_document_compiler
{
    /**
     * Header as HTML.
     *
     * @var  string
     */
    protected $m_header;

    /**
     * Footer as HTML.
     *
     * @var  string
     */
    protected $m_footer;

    /**
     * Array of isys_document_compiler_chapter.
     *
     * @var  isys_document_compiler_model_chapter[]
     */
    private $m_chapters = [];

    /**
     * Document type.
     *
     * @var  string
     */
    protected $m_document_type;

    /**
     * Set document type.
     *
     * @param   string $p_value
     *
     * @return  isys_document_compiler_document
     */
    public function set_document_type($p_value = null)
    {
        $this->m_document_type = $p_value;

        return $this;
    }

    /**
     * Get document type.
     *
     * @return  string
     */
    public function get_document_type()
    {
        return $this->m_document_type;
    }

    /**
     * Set header.
     *
     * @param   string $p_value
     *
     * @return  isys_document_compiler_document
     */
    public function set_header($p_value = null)
    {
        $this->m_header = $p_value;

        return $this;
    }

    /**
     * Get header.
     *
     * @return  string
     */
    public function get_header()
    {
        return $this->m_header;
    }

    /**
     * Get footer.
     *
     * @return  string
     */
    public function get_footer()
    {
        return $this->m_footer;
    }

    /**
     * Set footer
     *
     * @param   string $p_value
     *
     * @return  isys_document_compiler_document
     */
    public function set_footer($p_value = null)
    {
        $this->m_footer = $p_value;

        return $this;
    }

    /**
     * Add Chapter.
     *
     * @param  isys_document_compiler_chapter $p_chapterObj
     */
    public function add_chapter(isys_document_compiler_chapter $p_chapterObj)
    {
        $this->m_chapters[] = $p_chapterObj;
    }

    /**
     * Get all chapters of document as array.
     *
     * @return  array
     */
    public function get_chapters()
    {
        return $this->m_chapters;
    }

    /**
     * Clear all chapters.
     */
    public function clear_chapters()
    {
        $this->m_chapters = [];
    }

    /**
     * Compile this document.
     *
     * @return  isys_document_compiler_document
     */
    protected function get()
    {
        $l_chapter_models = $this->get_model()
            ->get_chapters();

        foreach ($l_chapter_models as $l_chapter_model) {
            // Prepare chapter compiler.
            $l_chapter_compiler = new isys_document_compiler_chapter($l_chapter_model);

            $l_chapter_compiler->set_document($this)
                ->compile();

            // Add the current chapter to the document.
            $this->add_chapter($l_chapter_compiler);
        }

        if (isset($this->m_chapters[0])) {
            // Compile header and footer.
            $this->get_model()
                ->set_index(self::compile_html($this->get_model()->get_raw_index(), $this->m_chapters[0]))
                ->set_header(self::compile_html($this->get_model()->get_raw_header(), $this->m_chapters[0]))
                ->set_footer(self::compile_html($this->get_model()->get_raw_footer(), $this->m_chapters[0]));
        }

        return $this;
    }

    /**
     * Init.
     */
    protected function init()
    {
        ;
    }

    /**
     * Post-Compile Routine.
     */
    protected function post()
    {
        ;
    }

    /**
     * Pre-Compile Routine.
     */
    protected function pre()
    {
        ;
    }

    /**
     * Refresh content of existing documents.
     *
     * @param  integer $documentId
     *
     * @param string   $comment
     *
     * @throws \idoit\Exception\JsonException
     * @throws isys_exception_dao
     * @throws isys_exception_database
     * @throws isys_exception_general
     */
    public static function refresh_document($documentId, $comment = '')
    {
        global $g_dirs;

        $session = isys_application::instance()->container->get('session');
        $language = isys_application::instance()->container->get('language');
        $database = isys_application::instance()->container->get('database');

        if (is_numeric($documentId) && $documentId > 0) {
            $l_document_dao = new isys_document_dao($database);
            $l_document_template_dao = new isys_document_dao_templates($database);
            $l_document_chapter_dao = new isys_document_dao_chapters($database);
            $l_dao_person = new isys_cmdb_dao_category_s_person_master($database);

            $l_person_data = $l_dao_person->get_data(null, $session->get_user_id())
                ->get_row();
            $l_document_data = $l_document_dao->get_data($documentId)
                ->get_row();

            if ($l_document_data['isys_document__isys_document_template__id']) {
                // Prepare document model.
                $l_template_data = $l_document_template_dao->get_data($l_document_data['isys_document__isys_document_template__id'])
                    ->get_row();

                if (is_array($l_template_data)) {
                    $l_options = [];

                    if (isys_format_json::is_json($l_template_data['isys_document_template__options'])) {
                        $l_options = isys_format_json::decode($l_template_data['isys_document_template__options']);
                    }

                    // Set document compiler model. PHP 5.4 style!
                    $l_model_document = (new isys_document_compiler_model_document($l_options))
                        ->set_author($l_person_data['isys_cats_person_list__first_name'] . ' ' . $l_person_data['isys_cats_person_list__last_name'])
                        ->set_title($l_document_data['isys_document__title'])
                        ->set_created(time())
                        ->set_raw_index($l_template_data['isys_document_template__index'])
                        ->set_raw_header($l_template_data['isys_document_template__header'])
                        ->set_raw_footer($l_template_data['isys_document_template__footer'])
                        ->set_document_type(_L($l_template_data['isys_document_type__title']))
                        ->setCustomFields((new CustomFieldsRepository())->getCustomFieldsForDocument($documentId))
                        ->setDescription($l_document_data['isys_document__description'])
                        ->clear_chapters();

                    // Load chapter models.
                    $l_model_document->load($l_template_data['isys_document_template__id'], $l_document_chapter_dao);

                    // Create document compiler.
                    $l_compiler_document = new isys_document_compiler_document($l_model_document);
                    isys_document_compiler_document::set_global_master_object($l_document_data['isys_obj__id']);
                    isys_document_compiler_chapter::set_global_master_object($l_document_data['isys_obj__id']);

                    // Compile our document.
                    if ($l_compiler_document->compile()) {
                        // Update header and footer.
                        $l_document_dao->saveDocument($l_document_data['isys_document__id'], [
                            'created' => date('Y-m-d H:i:s'),
                        ]);

                        isys_document_dao_revision::create_revision($l_document_data['isys_document__id'], $l_compiler_document->get_model(), $session->get_user_id(), $comment);

                        // @see  DOKU-244  When all went well, we create logbook entry.
                        $documentLink = isys_helper_link::create_url([
                            C__GET__MODULE_ID => C__MODULE__DOCUMENT,
                            C__GET__SETTINGS_PAGE => 'documents',
                            'action' => 'edit',
                            C__GET__ID => $l_document_data['isys_document__id']
                        ], true);

                        // @see  DOKU-197  Documents should receive an own title.
                        $documentHTMLLink = '<a href="' . $documentLink . '">' . ($l_document_data['isys_document__title'] ?: $l_document_data['isys_document_template__title']) . '</a>';

                        isys_component_dao_logbook::instance($database)
                            ->set_entry(
                                $language->get('LC__MODULE__DOCUMENT__NEW_REVISION', $documentHTMLLink),
                                'Created by ' . $l_person_data['isys_obj__title'] . '<br />Created at ' . date('Y-m-d H:i:s'),
                                null,
                                C__LOGBOOK__ALERT_LEVEL__0,
                                $l_document_data['isys_obj__id'],
                                $language->get($l_document_data['isys_obj__title']),
                                $language->get($l_dao_person->get_objtype_name_by_id_as_string($l_document_data['isys_obj__isys_obj_type__id'])),
                                $language->get('LC__CMDB__CATG__DOCUMENT'),
                                C__LOGBOOK_SOURCE__INTERNAL,
                                '',
                                '', // @todo  DOKU-23  Comment/Reason for new revision.
                                '' // @todo  DOKU-23  Comment/Reason for new revision.
                            );
                    }
                }
            } else {
                throw new isys_exception_general(_L('LC__MODULE__DOCUMENT__ERROR__NO_LINKED_TEMPLATE'));
            }
        }
    }
}
