<?php

/**
 * i-doit
 * Chapter Store Model
 *
 * @package     i-doit
 * @subpackage  Modules
 * @author      Selcuk Kekec <skekec@i-doit.com>
 * @version     1.0.0
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       i-doit 1.4.0
 */
class isys_document_compiler_model_chapter extends isys_document_compiler_model
{
    /**
     * @var isys_document_compiler_model_document|null
     */
    protected ?isys_document_compiler_model_document $m_document = null;

    /**
     * @var string
     */
    protected string $m_chapter_num;

    /**
     * @var string
     */
    protected string $m_raw_text;

    /**
     * @var string
     */
    protected string $m_compiled_text;

    /**
     * @var int
     */
    protected int $level;

    /**
     * @var bool
     */
    protected bool $newPage = false;

    /**
     * @return bool
     */
    public function get_new_page(): bool
    {
        return $this->newPage;
    }

    /**
     * @param bool $p_value
     *
     * @return $this
     */
    public function set_new_page(bool $p_value): self
    {
        $this->newPage = $p_value;

        return $this;
    }

    /**
     * @return string
     */
    public function get_chapter_num(): string
    {
        return $this->m_chapter_num;
    }

    /**
     * @param string $p_chapter_num
     *
     * @return $this
     */
    public function set_chapter_num(string $p_chapter_num): self
    {
        $this->m_chapter_num = $p_chapter_num;

        return $this;
    }

    /**
     * @return int
     */
    public function get_level(): int
    {
        return $this->level;
    }

    /**
     * @param int $p_level
     *
     * @return $this
     */
    public function set_level(int $p_level): self
    {
        $this->level = $p_level;

        return $this;
    }

    /**
     * @return string
     */
    public function get_compiled_text(): string
    {
        return $this->m_compiled_text;
    }

    /**
     * @param string $p_compiled_text
     *
     * @return $this
     */
    public function set_compiled_text(string $p_compiled_text): self
    {
        $this->m_compiled_text = $p_compiled_text;

        return $this;
    }

    /**
     * @return string
     */
    public function get_raw_text(): string
    {
        return $this->m_raw_text;
    }

    /**
     * @param string $p_raw_text
     *
     * @return $this
     */
    public function set_raw_text(string $p_raw_text): self
    {
        // @see  DOKU-184  Removed "utf8_decode()".
        $this->m_raw_text = $p_raw_text;

        return $this;
    }

    /**
     * @return isys_document_compiler_model_document
     */
    public function get_document(): isys_document_compiler_model_document
    {
        return $this->m_document;
    }

    /**
     * @param isys_document_compiler_model_document $p_value
     *
     * @return $this
     */
    public function set_document(isys_document_compiler_model_document $p_value): self
    {
        $this->m_document = $p_value;

        return $this;
    }
}
