<?php

/**
 * Class for isys_document text formats
 *
 * @package     i-doit
 * @subpackage  Modules
 * @author      Dennis Stücken <dstuecken@syneticd.de>
 * @version     1.1
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
abstract class isys_document_format_text implements isys_document_formattable
{
    /**
     * HTML Content.
     *
     * @var  string
     */
    protected $m_content = '';

    /**
     * The format options.
     *
     * @var  array
     */
    protected $m_options = [];

    /**
     * Initialize formatter.
     *
     * @param   array $options
     */
    public function initialize(array $options): void
    {
        $this->m_options = $options;
    }

    /**
     * Write formatted content to $p_filename.
     *
     * @param string $p_filename
     *
     * @return $this
     * @throws Exception
     */
    public function save(string $p_filename): self
    {
        if (is_writable(dirname($p_filename))) {
            file_put_contents($p_filename, $this->m_content);
        } else {
            throw new Exception('Directory ' . dirname($p_filename) . ' is not writable.');
        }

        return $this;
    }

    /**
     * Send formatted content to browser.
     *
     * @param string $p_filename
     * @param bool   $p_inline
     *
     * @return $this
     */
    public function send(string $p_filename, bool $p_inline = false): self
    {
        echo $this->m_content;

        return $this;
    }

    /**
     * @return $this
     */
    public function afterExport(): self
    {
        return $this;
    }

    /**
     * @return $this
     */
    public function beforeExport(): self
    {
        return $this;
    }

    /**
     * @return $this
     */
    public function addNewPage(): self
    {
        return $this;
    }

    /**
     * @return array
     */
    public function getFormatOptionDefinition(): array
    {
        return [];
    }

    /**
     * @return string
     */
    public function getContent(): string
    {
        return $this->m_content;
    }
}
