<?php

/**
 * i-doit
 * Popup class for creating images placeholder
 *
 * @package     i-doit
 * @subpackage  Popups
 * @author      Van Quyen Hoang <qhoang@i-doit.com>
 * @version     1.0
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_popup_document_placeholder_images extends isys_component_popup
{
    /**
     * Handle request.
     *
     * @param  isys_module_request $moduleRequest
     *
     * @return void
     */
    public function &handle_module_request(isys_module_request $moduleRequest)
    {
        global $g_config;

        $l_dao_images = new isys_cmdb_dao_category_g_images($this->database);

        if ($_GET[C__GET__FILE__ID]) {
            echo $l_dao_images->load_image((int)$_GET[C__GET__FILE__ID]);
            die;
        }

        if (isset($_GET['load'], $_POST[C__CMDB__GET__OBJECT]) && $_GET['load'] > 0 && $_POST[C__CMDB__GET__OBJECT] > 0) {
            $l_return = [
                'success' => true,
                'data'    => null,
                'message' => null
            ];

            try {
                $l_res = $l_dao_images->get_images_by_object($_POST[C__CMDB__GET__OBJECT]);

                if (count($l_res)) {
                    $l_data = [
                        'count'  => count($l_res),
                        'images' => []
                    ];

                    while ($l_row = $l_res->get_row()) {
                        $l_data['images'][] = [
                            'image_id'       => $l_row['isys_catg_images_list__id'],
                            'image_filename' => $l_row['isys_catg_images_list__filename'],
                        ];
                    }
                } else {
                    $l_data = [
                        'count'  => 0,
                        'images' => false
                    ];
                }

                $l_return['data'] = $l_data;
            } catch (Exception $e) {
                $l_return = [
                    'success' => false,
                    'data'    => null,
                    'message' => $e->getMessage()
                ];
            }

            header('Content-Type: application/json; charset=UTF-8');

            echo isys_format_json::encode($l_return);

            die;
        }

        $this->template
            ->assign('ajax_url', isys_helper_link::create_url($_GET))
            ->assign('image_url', $g_config['www_dir'] . 'src/classes/modules/document/images/')
            ->display(isys_module_document::getPath() . 'templates/popup/placeholder_images.tpl');

        die();
    }
}
