[{isys_group name="tom.popup.placeholder"}]
	<div id="document-popup">
        <div class="popup-header-ng">
            <h1>[{isys type="lang" ident="LC__MODULE__DOCUMENT__POPUP_P__REPORT__HEADER"}]</h1>
            <button type="button" class="btn btn-secondary popup-closer ml-auto" title="[{isys type="lang" ident="LC__POPUP__CLOSE"}]" data-tooltip="1">
                <img class="fr mouse-pointer" alt="" src="[{$dir_images}]axialis/user-interface/window-control-close.svg" />
            </button>
        </div>

		<div class="popup-content">
			<table class="contentTable">
				<tr>
					<td class="key">[{isys type="f_label" ident="LC__WIDGET__REPORTS" name="document-popup-report-selection"}]</td>
					<td class="value">[{isys type="f_dialog" name="document-popup-report-selection"}]</td>
				</tr>
				<tr>
					<td colspan="2">
						<hr class="mt5 mb5" />
					</td>
				</tr>
				<tr>
					<td class="key">[{isys type="f_label" ident="LC__MODULE__DOCUMENT__PLACEHOLDER__REPORT__DISPLAY_TITLE" name="document-popup-report-show-title"}]</td>
					<td class="value">[{isys type="checkbox" name="document-popup-report-show-title"}]</td>
				</tr>
				<tr>
					<td class="key">[{isys type="f_label" ident="LC__MODULE__DOCUMENT__PLACEHOLDER__REPORT__DISPLAY_DESCRIPTION" name="document-popup-report-display-description"}]</td>
					<td class="value">[{isys type="f_dialog" name="document-popup-report-display-description"}]</td>
				</tr>
				<tr>
					<td colspan="2">
						<hr class="mt5 mb5" />
					</td>
				</tr>
				<tr>
					<td class="key">[{isys type="f_label" ident="LC__MODULE__DOCUMENT__PLACEHOLDER__REPORT__DISPLAY_HEADER" name="document-popup-report-show-header"}]</td>
					<td class="value">
						[{isys type="checkbox" name="document-popup-report-show-header"}]

						<button type="button" class="btn header-style ml10" value="b" title="bold" data-tooltip="1"><img src="[{$dir_images}]axialis/word-processing/character-bold.svg" /></button>
						<button type="button" class="btn header-style" value="i" title="italic" data-tooltip="1"><img src="[{$dir_images}]axialis/word-processing/character-italic.svg" /></button>
						<button type="button" class="btn header-style" value="u" title="underline" data-tooltip="1"><img src="[{$dir_images}]axialis/word-processing/character-underline.svg" /></button>

						<button type="button" class="btn header-alignment ml10" value="left" data-tooltip="1" title="[{isys type="lang" ident="LC__MODULE__DOCUMENT__PLACEHOLDER__REPORT__HEADER_ALIGN_LEFT" p_bHtmlEncode=false}]">
							<img src="[{$dir_images}]axialis/word-processing/paragraph-align-left.svg" />
						</button>
						<button type="button" class="btn header-alignment" value="center" data-tooltip="1" title="[{isys type="lang" ident="LC__MODULE__DOCUMENT__PLACEHOLDER__REPORT__HEADER_ALIGN_CENTER" p_bHtmlEncode=false}]">
							<img src="[{$dir_images}]axialis/word-processing/paragraph-align-center.svg" />
						</button>
						<button type="button" class="btn header-alignment" value="right" data-tooltip="1" title="[{isys type="lang" ident="LC__MODULE__DOCUMENT__PLACEHOLDER__REPORT__HEADER_ALIGN_RIGHT" p_bHtmlEncode=false}]">
							<img src="[{$dir_images}]axialis/word-processing/paragraph-align-right.svg" />
						</button>
					</td>
				</tr>
				<tr>
					<td class="key">[{isys type="f_label" ident="LC__MODULE__DOCUMENT__PLACEHOLDER__REPORT__HEADER_BACKGROUND" name="document-popup-report-header-background"}]</td>
					<td class="value">[{isys type="f_colorpicker" name="document-popup-report-header-background"}]</td>
				</tr>
				<tr>
					<td class="key">[{isys type="f_label" ident="LC__MODULE__DOCUMENT__PLACEHOLDER__REPORT__HEADER_TEXTCOLOR" name="document-popup-report-header-textcolor"}]</td>
					<td class="value">[{isys type="f_colorpicker" name="document-popup-report-header-textcolor"}]</td>
				</tr>
				<tr>
					<td colspan="2">
						<hr class="mt5 mb5" />
					</td>
				</tr>
				<tr>
					<td class="key">[{isys type="f_label" ident="LC__MODULE__DOCUMENT__PLACEHOLDER__REPORT__DISPLAY_GRID" name="document-popup-report-show-grid"}]</td>
					<td class="value">[{isys type="f_dialog" name="document-popup-report-show-grid"}]</td>
				</tr>
				<tr>
					<td class="key">[{isys type="f_label" ident="LC__MODULE__DOCUMENT__PLACEHOLDER__REPORT__ZEBRA_GRID" name="document-popup-report-zebra-grid"}]</td>
					<td class="value">[{isys type="f_colorpicker" name="document-popup-report-zebra-grid"}]</td>
				</tr>
				<tr>
					<td class="key">[{isys type="f_label" ident="LC__MODULE__DOCUMENT__PLACEHOLDER__REPORT__DISPLAY_AFTER_PAGE_BREAK" name="document-popup-report-show-after-page-break"}]</td>
					<td class="value">[{isys type="f_dialog" name="document-popup-report-show-after-page-break"}]</td>
				</tr>
				<!--
				DOKU-173 - this is currently not possible.
				<tr>
					<td class="key">[{isys type="f_label" ident="LC__MODULE__DOCUMENT__PLACEHOLDER__REPORT__DISPLAY_PAGE_BREAK" name="document-popup-report-format-display-page-break"}]</td>
					<td class="value">[{isys type="f_dialog" name="document-popup-report-format-display-page-break"}]</td>
				</tr>
				-->
			</table>
		</div>

		<div class="popup-footer-ng">
			<button type="button" class="btn mr5" id="document-popup-save-button">
				<img src="[{$dir_images}]axialis/basic/symbol-ok.svg"><span>[{isys type="lang" ident="LC__CMDB__OBJECT_BROWSER__SCRIPT__ADD"}]</span>
			</button>
			<button type="button" class="btn popup-closer">
				<img src="[{$dir_images}]axialis/basic/symbol-cancel.svg"><span>[{isys type="lang" ident="LC__UNIVERSAL__BUTTON_CANCEL"}]</span>
			</button>
		</div>
	</div>
	<script type="text/javascript">
        (function () {
            "use strict";

            var widget                  = window.currently_selected_document_widget,
                widgetData              = widget.data,
                $popup                  = $('popup_placeholder').stopObserving(),
                $reportSelect           = $('document-popup-report-selection'),
                $reportShowTitle        = $('document-popup-report-show-title'),
                $reportShowDescription  = $('document-popup-report-display-description'),
                $showGrid               = $('document-popup-report-show-grid'),
                $zebraGrid              = $('document-popup-report-zebra-grid'),
                $showAfterPageBreak     = $('document-popup-report-show-after-page-break'),
                $reportShowHeader       = $('document-popup-report-show-header'),
                $reportHeaderBackground = $('document-popup-report-header-background'),
                $reportHeaderTextcolor  = $('document-popup-report-header-textcolor');

            // Preselect the report
            if (widgetData.hasOwnProperty('data') && widgetData.data.hasOwnProperty('id') && widgetData.data.id > 0) {
                $reportSelect.setValue(widgetData.data.id);
            }

            // Here we reformat possible old configurations to fit the new ones:
            if (widgetData.data.hasOwnProperty('optBorder')) {
	            widgetData.data.showGrid = (widgetData.data.optBorder ? 'all' : 0);
            }

            // Preselect checkboxes.
            if (!widgetData.data.hasOwnProperty('optHeader')) {
                widgetData.data.optHeader = false;
            }

            if (!widgetData.data.hasOwnProperty('headerTextAlignment')) {
                widgetData.data.headerTextAlignment = 'left';
            }

            if (!widgetData.data.hasOwnProperty('headerTextStyle')) {
                widgetData.data.headerTextStyle = 'b';
            }

            if (!widgetData.data.hasOwnProperty('headerBackground')) {
                widgetData.data.headerBackground = 'ffffff';
            }

            if (!widgetData.data.hasOwnProperty('headerTextcolor')) {
                widgetData.data.headerTextcolor = '#000000';
            }

            if (!widgetData.data.hasOwnProperty('showTitle')) {
                widgetData.data.showTitle = false;
            }

            if (!widgetData.data.hasOwnProperty('showDescription')) {
                widgetData.data.showDescription = 0;
            }

            if (!widgetData.data.hasOwnProperty('showGrid')) {
                widgetData.data.showGrid = 'all';
            }

            if (!widgetData.data.hasOwnProperty('zebraGrid')) {
                widgetData.data.zebraGrid = '#ffffff';
            }

            if (!widgetData.data.hasOwnProperty('showAfterPageBreak')) {
                widgetData.data.showAfterPageBreak = 1;
            }

            try {
                $popup.down('.btn.header-alignment[value="' + widgetData.data.headerTextAlignment + '"]').addClassName('pressed');
            } catch (e) {
                $popup.down('.btn.header-alignment').addClassName('pressed');
            }

            if (widgetData.data.headerTextStyle.indexOf('b') >= 0) {
                $popup.down('.btn.header-style').addClassName('pressed')
            }

            if (widgetData.data.headerTextStyle.indexOf('i') >= 0) {
                $popup.down('.btn.header-style', 1).addClassName('pressed')
            }

            if (widgetData.data.headerTextStyle.indexOf('u') >= 0) {
                $popup.down('.btn.header-style', 2).addClassName('pressed')
            }

            $reportShowHeader.on('change', function () {
                if ($reportShowHeader.checked) {
                    $reportHeaderBackground.enable();
                    $reportHeaderTextcolor.enable();
                    $popup.down('.popup-content').select('.btn').invoke('enable');
                } else {
                    $reportHeaderBackground.disable();
                    $reportHeaderTextcolor.disable();
                    $popup.down('.popup-content').select('.btn').invoke('disable');
                }
            });

            $reportShowHeader.setValue(widgetData.data.optHeader ? 1 : 0).simulate('change');
            $reportHeaderBackground.setValue(widgetData.data.headerBackground.substring(0, 1) === '#' ? widgetData.data.headerBackground : '#' + widgetData.data.headerBackground).simulate('change');
            $reportHeaderTextcolor.setValue(widgetData.data.headerTextcolor.substring(0, 1) === '#' ? widgetData.data.headerTextcolor : '#' + widgetData.data.headerTextcolor).simulate('change');
            $reportShowTitle.setValue(widgetData.data.showTitle ? 1 : 0);
            $reportShowDescription.setValue(widgetData.data.showDescription);
            $showGrid.setValue(widgetData.data.showGrid);
            $zebraGrid.setValue(widgetData.data.zebraGrid.substring(0, 1) === '#' ? widgetData.data.zebraGrid : '#' + widgetData.data.zebraGrid).simulate('change');
            $showAfterPageBreak.setValue(widgetData.data.showAfterPageBreak);

            $popup.on('click', '.popup-closer', function () {
                // If the user closes the popup, we want to destroy the widget!
                if (widget.data.data && widget.data.data.hasOwnProperty('id') && !widget.data.data.id) {
                    widget.remove_and_set_focus();
                }

                popup_close($popup);

                window.currentEditor.focus();
            });

            $popup.on('click', '.btn.header-alignment', function(ev) {
                $popup.select('.btn.header-alignment').invoke('removeClassName', 'pressed');

                ev.findElement('button').addClassName('pressed');
            });

            $popup.on('click', '.btn.header-style', function(ev) {
                ev.findElement('button').toggleClassName('pressed');
            });

            // And add some "accept" logic.
            $('document-popup-save-button').on('click', function (ev) {
                ev.preventDefault();

                var data = {};

                if ($reportSelect.getValue() > 0) {
                    // Input a complete category table.
                    data = {
                        widget_type: 'report',
                        data: {
                            id:                  $reportSelect.getValue(),
                            name:                $reportSelect.down('option:selected').text,
                            showTitle:           $reportShowTitle.checked,
                            optHeader:           $reportShowHeader.checked,
                            headerBackground:    $reportHeaderBackground.getValue(),
                            headerTextcolor:     $reportHeaderTextcolor.getValue(),
                            headerTextAlignment: $popup.down('.btn.header-alignment.pressed').getValue(),
                            headerTextStyle:     $popup.select('.btn.header-style.pressed').invoke('getValue').join(''),
                            showDescription:     $reportShowDescription.getValue(),
                            showGrid:            $showGrid.getValue(),
                            zebraGrid:           $zebraGrid.getValue(),
                            showAfterPageBreak:  $showAfterPageBreak.getValue()
                        }
                    };

                    widget.setData(data);
                }

                popup_close($popup);

                window.currentEditor.focus();
            });
        })();
	</script>
[{/isys_group}]
