<?php

/**
 * i-doit
 *
 * Module initializer.
 *
 * @package     i-doit
 * @subpackage  Modules
 * @author      Selcuk Kekec <skekec@i-doit.com>
 * @version     1.1
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */

use idoit\Component\Autoloader;
use idoit\Component\Download\DownloadType;
use idoit\Component\Upload\UploadType;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\Routing\Loader\PhpFileLoader;

if (isys_module_manager::instance()->is_active('document')) {
    // Use this to throw exceptions instead of simply ending the request.
    if (!defined('K_TCPDF_THROW_EXCEPTION_ERROR')) {
        define('K_TCPDF_THROW_EXCEPTION_ERROR', true);
    }

    // Define some constants.
    define('C__DOCUMENT__ROOT__DIR', __DIR__ . '/');
    define('C__DOCUMENT__GET__DOCUMENT_ID', 'docID');
    define('C__DOCUMENT__GET__REVISION_ID', 'revisionID');

    // Autoloader.
    Autoloader::appendClassmap(require_once __DIR__ . '/classmap.php');

    // Register CLI controller.
    $GLOBALS['g_controller']['handler']['document'] = ['class' => 'isys_handler_document'];

    if (class_exists('\idoit\Psr4AutoloaderClass')) {
        \idoit\Psr4AutoloaderClass::factory()->addNamespace('idoit\Module\Document', __DIR__ . '/src/');
    }

    // Add 'document' relevant routes.
    isys_application::instance()->container->get('routes')
        ->addCollection((new PhpFileLoader(new FileLocator(__DIR__)))->load('config/routes.php'));

    // idoit.addon.document.revision.commentable
    isys_tenantsettings::extend([
        'LC__MODULE__DOCUMENT' => [
            'idoit.addon.document.revision.commentable' => [
                'title'   => 'LC__MODULE__DOCUMENT__REVISION_COMMENTABLE',
                'type'    => 'select',
                'options' => [
                    '0' => 'LC__UNIVERSAL__NO',
                    '1' => 'LC__UNIVERSAL__YES'
                ],
                'default' => '0'
            ],
            'idoit.addon.document.caching'              => [
                'title'   => 'LC__MODULE__DOCUMENT__CACHING',
                'type'    => 'select',
                'options' => [
                    '0' => 'LC__UNIVERSAL__NO',
                    '1' => 'LC__UNIVERSAL__YES'
                ],
                'default' => '1'
            ]
        ]
    ]);

    isys_application::instance()->container->get('download')
        ->registerDownloadType('document.export-template', new DownloadType([isys_module_document::class, 'getTemplateExportPath']));

    isys_application::instance()->container->get('upload')
        ->registerUploadType('document.import-template', (new UploadType())
            ->setCallbackAfterUpload([isys_module_document::class, 'importByZip'])
            ->setUploadDirectory('/temp/')
            ->setValidExtensions(['zip']));

    // Add the document widget.
    isys_register::factory('widget-register')
        ->set('reports', 'isys_dashboard_widgets_document_last_revisions');

    // Attach custom stylesheet.
    isys_component_signalcollection::get_instance()
        ->connect('mod.css.attachStylesheet', function () {
            return __DIR__ . '/assets/css/document.css';
        });

    isys_register::factory('additional-dialog-admin-tables')
        ->set('isys_document_revision_reasons');
}
