<?php

/**
 * i-doit
 * Popup class for creating report placeholder
 *
 * @package     i-doit
 * @subpackage  Popups
 * @author      Selcuk Kekec <skekec@i-doit.de>
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @version     1.0
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_popup_document_placeholder_report extends isys_component_popup
{
    /**
     * Handle request.
     *
     * @param   isys_module_request $p_modreq
     *
     * @return  void
     */
    public function &handle_module_request(isys_module_request $p_modreq)
    {
        $reports = [];

        $l_allowed_reports = isys_auth_report::instance()
            ->get_allowed_reports();

        $l_res = isys_report_dao::instance(isys_application::instance()->container->get('database_system'))
            ->get_reports(null, $l_allowed_reports ?: 0, null, true);

        if (count($l_res) > 0) {
            while ($l_row = $l_res->get_row()) {
                $reports[$l_row['isys_report_category__title']][$l_row['isys_report__id']] = $l_row['isys_report__title'] . ' ' .
                    ((int)$l_row['isys_report__category_report'] === 1 ? $this->language->get('LC__MODULE__DOCUMENT__PLACEHOLDER__REPORT__PLACEHOLDER_REPORT') : '');
            }
        }

        $rules = [
            'document-popup-report-selection'             => [
                'p_arData'        => $reports,
                'p_bSort'         => false,
                'p_strSelectedID' => 0,
                'p_bDbFieldNN'    => true,
                'p_strClass'      => 'input-small'
            ],
            'document-popup-report-header-background'     => [
                'size'       => 'mini',
                'p_strValue' => '#ffffff',
                'parent'     => '#document-popup .popup-content'
            ],
            'document-popup-report-header-textcolor'      => [
                'size'       => 'mini',
                'p_strValue' => '#000000',
                'parent'     => '#document-popup .popup-content'
            ],
            'document-popup-report-display-description'   => [
                'p_arData'        => [
                    0       => $this->language->get('LC__UNIVERSAL__NO'),
                    'above' => $this->language->get('LC__MODULE__DOCUMENT__PLACEHOLDER__REPORT__DISPLAY_DESCRIPTION_ABOVE'),
                    'below' => $this->language->get('LC__MODULE__DOCUMENT__PLACEHOLDER__REPORT__DISPLAY_DESCRIPTION_BELOW')
                ],
                'p_bSort'         => false,
                'p_strSelectedID' => 0,
                'p_bDbFieldNN'    => true,
                'p_strClass'      => 'input-mini'
            ],
            'document-popup-report-show-grid'             => [
                'p_arData'        => [
                    0            => $this->language->get('LC__MODULE__DOCUMENT__PLACEHOLDER__REPORT__DISPLAY_GRID__NONE'),
                    'horizontal' => $this->language->get('LC__MODULE__DOCUMENT__PLACEHOLDER__REPORT__DISPLAY_GRID__HORIZONTAL'),
                    'vertical'   => $this->language->get('LC__MODULE__DOCUMENT__PLACEHOLDER__REPORT__DISPLAY_GRID__VERTICAL'),
                    'all'        => $this->language->get('LC__MODULE__DOCUMENT__PLACEHOLDER__REPORT__DISPLAY_GRID__ALL')
                ],
                'p_bSort'         => false,
                'p_strSelectedID' => 'all',
                'p_bDbFieldNN'    => true,
                'p_strClass'      => 'input-mini'
            ],
            'document-popup-report-zebra-grid'            => [
                'size'       => 'mini',
                'p_strValue' => '#ffffff',
                'parent'     => '#document-popup .popup-content'
            ],
            'document-popup-report-show-after-page-break' => [
                'p_arData'        => [
                    1 => $this->language->get('LC__MODULE__DOCUMENT__PLACEHOLDER__REPORT__DISPLAY_AFTER_PAGE_BREAK__YES'),
                    0 => $this->language->get('LC__MODULE__DOCUMENT__PLACEHOLDER__REPORT__DISPLAY_AFTER_PAGE_BREAK__NO')
                ],
                'p_bSort'         => false,
                'p_strSelectedID' => 1,
                'p_bDbFieldNN'    => true,
                'p_strClass'      => 'input-small'
            ]
        ];

        $this->template
            ->smarty_tom_add_rules('tom.popup.placeholder', $rules)
            ->display(isys_module_document::getPath() . 'templates/popup/placeholder_report.tpl');

        die();
    }
}
