<?php

namespace idoit\Module\Document\Controller;

use Exception;
use idoit\Controller\Base;
use idoit\Model\Dao\Base as DaoBase;
use idoit\Tree\Node;
use isys_application as Application;
use isys_component_tree as Tree;
use isys_controller as Controller;
use isys_module as Module;
use isys_register as Register;

/**
 * i-doit cmdb controller
 *
 * @package     Modules
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class Main extends Base implements Controller
{
    /**
     * @var Module
     */
    protected $module;

    /**
     * @param Register    $request
     * @param Application $application
     *
     * @return null
     */
    public function handle(Register $request, Application $application)
    {
        return null;
    }

    /**
     * @param Application $application
     *
     * @return DaoBase|\isys_component_dao
     * @throws Exception
     */
    public function dao(Application $application)
    {
        return DaoBase::instance($this->getDi()
            ->get('database'));
    }

    /**
     * @param Register    $request
     * @param Application $application
     * @param Tree        $tree
     *
     * @return Node
     */
    public function tree(Register $request, Application $application, Tree $tree)
    {
        return new Node('', '');
    }

    /**
     * @param Module $module
     */
    public function __construct(Module $module)
    {
        $this->module = $module;
    }
}
