<?php

namespace idoit\Module\Document\CustomFields\Value;

use DateTime;
use isys_application;
use isys_module_document;
use isys_smarty_plugin_f_popup;

/**
 * i-doit customfield date value.
 *
 * @package     document
 * @author      Kevin Mauel <kmauel@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       1.3.0
 */
class DateValue extends AbstractCustomFieldValue
{
    const LABEL = 'LC__MODULE__DOCUMENT__CUSTOM_FIELDS__VALUE__DATE';

    /**
     * @inheritdoc
     */
    public function getStringValue()
    {
        if (empty($this->value)) {
            return null;
        }

        return (new DateTime($this->value))->format('Y-m-d');
    }

    /**
     * @inheritdoc
     */
    public function getFormattedValue()
    {
        if (empty($this->value)) {
            return '';
        }

        return isys_application::instance()->container->get('locales')->fmt_date($this->value);
    }

    /**
     * @inheritdoc
     */
    public function getTemplate($name, $value, $editMode)
    {
        $smartyPlugin = new isys_smarty_plugin_f_popup();
        $template = isys_application::instance()->container->get('template');
        $parameters = [
            'id'             => $name,
            'name'           => $name,
            'p_strValue'     => $value,
            'p_strPopupType' => 'calendar',
            'p_strClass'     => 'input-small',
            'p_bEditMode'    => $editMode
        ];

        if ($editMode) {
            return $smartyPlugin->navigation_edit($template, $parameters);
        }

        return $smartyPlugin->navigation_view($template, $parameters);
    }
}
