"use strict";

/**
 * chapter.js
 */

// Set a custom "timestamp" so that CKEDITOR re-loads all necessary files.
window.CKEDITOR.timestamp = '[{isys_settings::get('system.last-change', time())}]';

// Load external ckeditor idoit plugin
CKEDITOR.plugins.addExternal('idoit', '[{isys_module_document::getWwwPath()}]js/idoit/', 'plugin.js');

if ($('chapterTabs'))
{
    new Tabs('chapterTabs', {
        wrapperClass: 'browser-tabs',
        contentClass: 'browser-tab-content',
        tabClass: 'mouse-pointer'
    });
}

/**
 * Copy content of chapter to actual chapter
 *
 * @param {type} param1
 * @param {type} param2
 */
$('copyComponent').observe('click', function() {
    if ($('C__CHAPTER__TEMPLATE_COMPONENT_COPY'))
    {
        if ($('C__CHAPTER__TEMPLATE_COMPONENT_COPY').value > -1) {
            new Ajax.Request('?[{$smarty.const.C__GET__MODULE_ID}]=[{$smarty.const.C__MODULE__DOCUMENT}]&ajax=1&call=document&method=getComponentText', {
                method: 'post',
                parameters: {
                    componentID: $F('C__CHAPTER__TEMPLATE_COMPONENT_COPY')
                },
                onSuccess: function(transport) {
                    /* Set HTML of copied chapter */
                    CKEDITOR.instances['C__CHAPTER__TEXT'].setData(transport.responseText);
                    CKEDITOR.instances['C__CHAPTER__TEXT'].updateElement();

                    /* Create notification */
                    idoit.Notify.success('[{isys type="lang" ident="LC__MODULE__DOCUMENT__NOTIFICATION__COPY__SUCCESS"}]');
                }
            });
        } else {
            idoit.Notify.error('[{isys type="lang" ident="LC__MODULE__DOCUMENT__NOTIFICATION__COPY__SELECT_CHAPTER"}]');
        }
    }
});

/**
 * Hide WYSWYG when component is setted
 *
 * @returns {undefined}
 */
var handle_copy = function() {
    if ($('C__CHAPTER__TEMPLATE_COMPONENT')) {
        if ($('C__CHAPTER__TEMPLATE_COMPONENT').value != -1) {
            $('chapterTabs', 'textContainer').invoke('hide');
	        $('chapterTemplateMessage').show();
        } else {
            $('chapterTabs', 'textContainer').invoke('show');
	        $('chapterTemplateMessage').hide();
        }
    }
};

/* Keepalive */
window.setInterval(function() {
    new Ajax.Call('?call=keepalive', { onSuccess: function(t){} });
}, 60 * 1000);

handle_copy();
