<?php

namespace idoit\Module\Document\Compiler\Placeholder;

use idoit\Module\Floorplan\Model\Floorplan as FloorplanModel;
use isys_application as Application;
use isys_module_document;

/**
 * i-doit "Floorplan" placeholder compiler.
 *
 * @package     document
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       1.4.1
 */
class Floorplan extends \isys_document_compiler_placeholder
{
    /**
     * Returns the compiled placeholder
     *
     * @return string
     */
    protected function get()
    {
        $application = Application::instance();
        $language = $application->container->get('language');
        $database = $application->container->get('database');

        if (!class_exists(FloorplanModel::class)) {
            return '<em>' . $language->get('LC__MODULE__DOCUMENT__POPUP_P__FLOORPLAN__INCOMPATIBLE_VERSION') . '</em>';
        }

        $floorplanModel = FloorplanModel::instance($database);

        if (!method_exists($floorplanModel, 'getFloorplanWithSnapshot')) {
            return '<em>' . $language->get('LC__MODULE__DOCUMENT__POPUP_P__FLOORPLAN__INCOMPATIBLE_VERSION') . '</em>';
        }

        $objectId = (int)$this->m_data['data']['objectId'];

        if ($objectId === 0) {
            $objectId = (int)$this->get_compiler()->get_master_object();
        }

        $floorplanData = $floorplanModel->getFloorplanWithSnapshot($objectId)->get_row();

        if (!$floorplanData || empty($floorplanData['snapshot'])) {
            $message = str_replace(
                [':title', ':id'],
                [$floorplanData['objectTitle'], $objectId],
                $language->get('LC__MODULE__DOCUMENT__POPUP_P__FLOORPLAN__PRESELECTION_WARNING')
            );

            return '<em>' . $message . '</em>';
        }

        // Filter away the BASE64 start string.
        $imageContent = base64_decode(substr($floorplanData['snapshot'], mb_strlen('data:image/png;base64,')));

        // We use a MD5 hash so that the same image will not create endless copies of itself.
        $revision = $this->m_dao_property
            ->retrieve('SELECT isys_document_revision__id FROM isys_document_revision ORDER BY isys_document_revision__id DESC LIMIT 1;')
            ->get_row_value('isys_document_revision__id');

        $filename = 'floorplan-' . $objectId . '.png';
        $imagePath = isys_module_document::get_temp_dir() . '/' . substr(md5($filename), 0, 8) . '_rev' . (1 + $revision) . '_' . $filename;

        if (!file_exists($imagePath)) {
            if (!is_dir(dirname($imagePath)) && !mkdir(dirname($imagePath), 0777, true)) {
                return '<em>' . $language->get('LC__MODULE__DOCUMENT__DOCUMENT_CREATION__RESOURCE_DIR_COULD_NOT_BE_CREATED', dirname($imagePath)) . '</em>';
            }

            if (is_writable(dirname($imagePath))) {
                if (!file_put_contents($imagePath, $imageContent)) {
                    return '<em>' . $language->get('LC__MODULE__DOCUMENT__DOCUMENT_CREATION__RESOURCE_FILE_COULD_NOT_BE_CREATED', $imagePath) . '</em>';
                }
            } else {
                return '<em>' . $language->get('LC__MODULE__DOCUMENT__DOCUMENT_CREATION__RESOURCE_DIR_NOT_WRITABLE', dirname($imagePath)) . '</em>';
            }
        }

        if (!file_exists($imagePath)) {
            return '<em>' . $language->get('LC__MODULE__DOCUMENT__DOCUMENT_CREATION__RESOURCE_IMAGE_COULD_NOT_BE_FOUND', $imagePath) . '</em>';
        }

        $imagePath = str_replace('\\', '/', $application->www_path . str_replace(BASE_DIR, '', $imagePath));

        return '<img src="' . $imagePath . '" style="display:block;" />';
    }

    /**
     * Pre-Compilation.
     *
     * @return mixed
     */
    protected function pre()
    {
    }

    /**
     * Post-Compilation.
     *
     * @return mixed
     */
    protected function post()
    {
    }
}
