<?php

namespace idoit\Module\Document\Compiler\Table;

/**
 * i-doit Table Compiler Config.
 *
 * @package     document
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       1.2.1
 */
class Config
{
    const GRID_NONE       = 0;
    const GRID_VERTICAL   = 'vertical';
    const GRID_HORIZONTAL = 'horizontal';
    const GRID_ALL        = 'all';

    const TEXT_ALIGN_LEFT   = 'left';
    const TEXT_ALIGN_CENTER = 'center';
    const TEXT_ALIGN_RIGHT  = 'right';

    const TEXT_STYLE_BOLD      = 'b';
    const TEXT_STYLE_ITALIC    = 'i';
    const TEXT_STYLE_UNDERLINE = 'u';

    /**
     * @var bool
     */
    private $showHeader = false;

    /**
     * @var string
     */
    private string $headerBackgroundColor = '#ffffff';

    /**
     * @var string
     */
    private string $headerTextColor = '#000000';

    /**
     * @var string
     */
    private $headerTextAlign = self::TEXT_ALIGN_LEFT;

    /**
     * @var string
     */
    private $headerTextStyle = '';

    /**
     * @var string
     */
    private $showGrid = self::GRID_ALL;

    /**
     * @var string
     */
    private string $zebraRowColor = '#ffffff';

    /**
     * @var bool
     */
    private $showHeaderAfterPageBreak = true;

    /**
     * @return bool
     */
    public function showHeader()
    {
        return $this->showHeader;
    }

    /**
     * @param bool $showHeader
     *
     * @return Config
     */
    public function setShowHeader($showHeader)
    {
        $this->showHeader = $showHeader;

        return $this;
    }

    /**
     * @return string
     */
    public function getHeaderBackgroundColor(): string
    {
        return $this->headerBackgroundColor;
    }

    /**
     * @param string $headerBackgroundColor
     *
     * @return Config
     */
    public function setHeaderBackgroundColor(string $headerBackgroundColor): self
    {
        $this->headerBackgroundColor = $headerBackgroundColor;

        return $this;
    }

    /**
     * @return string
     */
    public function getHeaderTextColor(): string
    {
        return $this->headerTextColor;
    }

    /**
     * @param string $headerTextColor
     *
     * @return Config
     */
    public function setHeaderTextColor(string $headerTextColor): self
    {
        $this->headerTextColor = $headerTextColor;

        return $this;
    }

    /**
     * @return string
     */
    public function getHeaderTextAlign()
    {
        return $this->headerTextAlign;
    }

    /**
     * @param string $headerTextAlign
     *
     * @return Config
     */
    public function setHeaderTextAlign($headerTextAlign)
    {
        $this->headerTextAlign = $headerTextAlign;

        return $this;
    }

    /**
     * @return string
     */
    public function getHeaderTextStyle()
    {
        return $this->headerTextStyle;
    }

    /**
     * @param string $headerTextStyle
     *
     * @return Config
     */
    public function setHeaderTextStyle($headerTextStyle)
    {
        $this->headerTextStyle = $headerTextStyle;

        return $this;
    }

    /**
     * @return string
     */
    public function getGrid()
    {
        return $this->showGrid;
    }

    /**
     * @param string $showGrid
     *
     * @return Config
     */
    public function setGrid($showGrid)
    {
        $this->showGrid = $showGrid;

        return $this;
    }

    /**
     * @return string
     */
    public function getZebraRowColor(): string
    {
        return $this->zebraRowColor;
    }

    /**
     * @param string $zebraRowColor
     *
     * @return Config
     */
    public function setZebraRowColor(string $zebraRowColor): self
    {
        $this->zebraRowColor = $zebraRowColor;

        return $this;
    }

    /**
     * @return bool
     */
    public function showHeaderAfterPageBreak()
    {
        return $this->showHeaderAfterPageBreak;
    }

    /**
     * @param bool $showHeaderAfterPageBreak
     *
     * @return Config
     */
    public function setShowHeaderAfterPageBreak($showHeaderAfterPageBreak)
    {
        $this->showHeaderAfterPageBreak = $showHeaderAfterPageBreak;

        return $this;
    }
}
