<?php

namespace idoit\Module\Document\CustomFields\Model;

use idoit\Model\Dao\Base;

/**
 * i-doit custom-fields configuration model.
 *
 * @package     document
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       1.3.0
 */
class Document extends Base
{
    /**
     * @param  integer $documentId
     *
     * @return \isys_component_dao_result
     * @throws \isys_exception_database
     */
    public function getByDocumentId($documentId)
    {
        $select = parent::selectImplode([
            'isys_document_custom_field_value__id'                             => 'id',
            'isys_document_custom_field_value__isys_document__id'              => 'documentId',
            'isys_document_custom_field_value__isys_document_custom_field__id' => 'customFieldId',
            'isys_document_custom_field_value__value'                          => 'fieldValue',
            'isys_document_custom_field__id'                                   => 'customFieldId',
            'isys_document_custom_field__isys_document_template__id'           => 'templateId',
            'isys_document_custom_field__name'                                 => 'name',
            'isys_document_custom_field__datatype'                             => 'dataType',
            'isys_document_custom_field__default_value'                        => 'defaultValue',
        ]);

        $sql = 'SELECT ' . $select . '
            FROM isys_document_custom_field
            LEFT JOIN isys_document_template ON isys_document_template__id = isys_document_custom_field__isys_document_template__id
            LEFT JOIN isys_document ON isys_document__isys_document_template__id = isys_document_template__id
            LEFT JOIN isys_document_custom_field_value ON isys_document_custom_field_value__isys_document_custom_field__id = isys_document_custom_field__id
                AND isys_document_custom_field_value__isys_document__id = isys_document__id
            WHERE isys_document__id = ' . $this->convert_sql_id($documentId) . '
            ORDER BY isys_document_custom_field__sorting ASC;';

        return $this->retrieve($sql);
    }

    /**
     * Retrieves the custom-field-value of a given document and custom-field.
     *
     * @param  integer $customFieldId
     * @param  integer $documentId
     *
     * @return array|null
     * @throws \isys_exception_database
     */
    private function getCustomFieldValue($customFieldId, $documentId)
    {
        $sql = 'SELECT * 
            FROM isys_document_custom_field_value
            WHERE isys_document_custom_field_value__isys_document__id = ' . $this->convert_sql_id($documentId) . '
            AND isys_document_custom_field_value__isys_document_custom_field__id = ' . $this->convert_sql_id($customFieldId);

        try {
            return $this->retrieve($sql)->get_row();
        } catch (\Exception $e) {
            return null;
        }
    }

    /**
     * Method for updating a custom field value.
     *
     * @param  integer $customFieldId
     * @param  integer $documentId
     * @param  string  $customFieldValue
     *
     * @return boolean
     * @throws \isys_exception_dao
     */
    public function saveCustomFieldValue($customFieldId, $documentId, $customFieldValue)
    {
        $fields = [
            'isys_document_custom_field_value__isys_document__id = ' . $this->convert_sql_id($documentId),
            'isys_document_custom_field_value__isys_document_custom_field__id = ' . $this->convert_sql_id($customFieldId),
            'isys_document_custom_field_value__value = ' . $this->convert_sql_text($customFieldValue)
        ];

        $customField = $this->getCustomFieldValue($customFieldId, $documentId);

        $sql = 'INSERT INTO isys_document_custom_field_value 
            SET ' . implode(', ', $fields) . ';';

        if (is_array($customField) && $customField['isys_document_custom_field_value__id'] > 0) {
            $sql = 'UPDATE isys_document_custom_field_value 
                SET ' . implode(', ', $fields) . ' 
                WHERE isys_document_custom_field_value__id = ' . $this->convert_sql_id($customField['isys_document_custom_field_value__id']) . ';';
        }

        return $this->update($sql) && $this->apply_update();
    }
}
