<?php

/**
 * i-doit
 *
 * Auth: Class for i-doit authorization rules.
 *
 * @package     Modules
 * @subpackage  Events
 * @author      Dennis Stücken <dstuecken@i-doit.de>
 * @version     1.5
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       i-doit 1.5
 */
class isys_auth_events extends isys_auth implements isys_auth_interface
{
    /**
     * Container for singleton instance
     *
     * @var isys_auth_check_mk
     */
    private static $m_instance;

    /**
     * Retrieve singleton instance of authorization class
     *
     * @return isys_auth_events
     * @author Selcuk Kekec <skekec@i-doit.com>
     */
    public static function instance()
    {
        // If the DAO has not been loaded yet, we initialize it now.
        if (self::$m_dao === null) {
            global $g_comp_database;

            self::$m_dao = new isys_auth_dao($g_comp_database);
        }

        if (self::$m_instance === null) {
            self::$m_instance = new self;
        }

        return self::$m_instance;
    }

    /**
     * Method for returning the available auth-methods. This will be used for the GUI.
     *
     * @return  array
     */
    public function get_auth_methods()
    {
        return [
            'hooks'   => [
                'title'  => 'Event-Hooks',
                'type'   => 'boolean',
                'rights' => [
                    isys_auth::VIEW,
                    isys_auth::EDIT
                ]
            ],
            'history' => [
                'title'  => 'LC__MODULE__EVENTS__HISTORY',
                'type'   => 'boolean',
                'rights' => [
                    isys_auth::VIEW,
                    isys_auth::EDIT,
                    isys_auth::DELETE
                ]
            ]
            /*,
			'config' => array(
				'title' => isys_application::instance()->container->get('language')->get('LC__CONFIGURATION'),
				'type' => 'boolean',
				'rights' => array(isys_auth::VIEW, isys_auth::EDIT)
			)*/
        ];
    }

    /**
     * Get ID of related module
     *
     * @return int
     */
    public function get_module_id()
    {
        return C__MODULE__EVENTS;
    }

    /**
     * Get title of related module
     *
     * @return string
     */
    public function get_module_title()
    {
        return 'LC__MODULE__EVENTS';
    }

    /**
     * Method for checking, if the user is allowed to manipulute hooks
     *
     * @param   integer $p_right
     *
     * @return  boolean
     * @throws  isys_exception_auth
     * @author  Dennis Stuecken <dstuecken@i-doit.com>
     */
    public function hooks($p_right)
    {
        if (!$this->is_auth_active()) {
            return true;
        }

        return $this->generic_right(
            $p_right,
            'hooks',
            self::EMPTY_ID_PARAM,
            new isys_exception_auth(isys_application::instance()->container->get('language')->get('LC__AUTH__EVENTS_EXCEPTION__MISSING_RIGHT_FOR_HOOKS'))
        );
    }

    /**
     * Method for checking, if the user is allowed to view the history
     *
     * @param   integer $p_right
     *
     * @return  boolean
     * @throws  isys_exception_auth
     * @author  Dennis Stuecken <dstuecken@i-doit.com>
     */
    public function history($p_right)
    {
        if (!$this->is_auth_active()) {
            return true;
        }

        return $this->generic_right(
            $p_right,
            'history',
            self::EMPTY_ID_PARAM,
            new isys_exception_auth(isys_application::instance()->container->get('language')->get('LC__AUTH__EVENTS_EXCEPTION__MISSING_RIGHT_FOR_HISTORY'))
        );
    }
}
