<?php
/**
 * i-doit
 *
 * Event Module initializer
 *
 * @package     Modules
 * @subpackage  Events
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */

use idoit\Module\Events\Component\Delegator;
use idoit\Psr4AutoloaderClass;

if (isys_module_manager::instance()->is_active('events')) {
    Psr4AutoloaderClass::factory()->addNamespace('idoit\Module\Events', __DIR__ . '/src/');

    include_once __DIR__ . '/isys_module_events_autoload.class.php';

    spl_autoload_register('isys_module_events_autoload::init');

    $session = isys_application::instance()->container->get('session');
    $database = isys_application::instance()->container->get('database');
    $language = isys_application::instance()->container->get('language');
    $signalSlots = isys_application::instance()->container->get('signals');

    if ($database && $session && $session->is_logged_in()) {
        $delegator = new Delegator($database, $language);

        $signalSlots
            ->connect('mod.cmdb.objectCreated', [$delegator, 'onObjectCreated'])
            ->connect('mod.cmdb.objectDeleted', [$delegator, 'onObjectDeleted'])
            ->connect('mod.cmdb.afterCreateCategoryEntry', [$delegator, 'onAfterCategoryEntryCreate'])
            ->connect('mod.cmdb.afterCategoryEntrySave', [$delegator, 'onAfterCategoryEntrySave'])
            ->connect('mod.cmdb.beforeRankRecord', [$delegator, 'onBeforeRankRecord'])
            ->connect('mod.cmdb.afterObjectTypeSave', [$delegator, 'onAfterObjectTypeSave'])
            ->connect('mod.cmdb.afterObjectTypePurge', [$delegator, 'onAfterObjectTypePurge']);
    }

    isys_tenantsettings::extend([
        'Events' => [
            'events.decodeArgs' => [
                'title'       => 'Base64 Decode Event Parameters',
                'type'        => 'select',
                'options'     => [
                    1 => 'LC__UNIVERSAL__YES',
                    0 => 'LC__UNIVERSAL__NO'
                ],
                'description' => 'Decodes json parameters passed to script in base64.',
                'default'     => 1
            ]
        ]
    ]);
}
