<?php

namespace idoit\Module\Events\Controller;

use idoit\Controller\Base;
use idoit\Controller\NavbarHandable;
use idoit\Module\Events\Component\EventParameter;
use idoit\Module\Events\Model\Dao;
use idoit\Module\Events\Model\ReferenceOption;
use idoit\Module\Events\Model\Subscription;
use idoit\Module\Events\View\Event;
use idoit\Module\Events\View\EventList;
use idoit\Tree\Node;
use isys_application as Application;
use isys_auth as Auth;
use isys_auth_events as AuthEvents;
use isys_component_template_navbar as ComponentNavbar;
use isys_controller as Controllable;
use isys_module as Module;
use isys_module_events as ModuleEvents;
use isys_register as Register;

/**
 * Class Ajax
 *
 * @package   idoit\Module\Events\Controller
 * @author    Leonard Fischer <lfischer@i-doit.com>
 * @copyright synetics GmbH
 * @license   http://www.i-doit.com/license
 */
class Ajax extends Base implements Controllable
{
    /**
     * @var Module
     */
    protected $module;
    protected $response;

    /**
     * Pre method gets called by the framework.
     *
     * @author  Leonard Fischer <lfischer@i-doit.com>
     */
    public function pre()
    {
        header('Content-Type: application/json');

        $this->response = [
            'success' => true,
            'data'    => null,
            'message' => null
        ];
    }

    /**
     * Default request handler, gets called in every /events request.
     *
     * @param  Register    $request
     * @param  Application $application
     *
     * @return \idoit\View\Renderable|void
     */
    public function handle(Register $request, Application $application)
    {
        return null;
    }

    public function loadReferenceOptions(Register $request)
    {
        try {
            $data = null;
            $reference = $request->get('POST')->get('reference');
            $language = $this->getDi()->get('language');
            $database = $this->getDi()->get('database');
            $dao = \isys_cmdb_dao::instance($database);

            switch ($reference) {
                case EventParameter::REFERENCE_OBJECT:
                    $data = ReferenceOption::instance($database)->getObjectTypes();
                    break;

                case EventParameter::REFERENCE_CATEGORY:
                    $data = ReferenceOption::instance($database)->getCategories();
                    break;
            }

            $this->response['data'] = $data;
        } catch (\Exception $e) {
            $this->response['success'] = false;
            $this->response['data'] = null;
            $this->response['message'] = $e->getMessage();
        }
    }

    /**
     * @param  Application $application
     *
     * @return \idoit\Model\Dao\Base|Dao
     * @throws \Exception
     */
    public function dao(Application $application)
    {
        return Dao::instance($application->container->get('database'));
    }

    /**
     * @param Register             $request
     * @param Application          $application
     * @param \isys_component_tree $tree
     *
     * @return Node|\isys_tree_node
     * @throws \Exception
     */
    public function tree(Register $request, Application $application, \isys_component_tree $tree)
    {
        return null;
    }

    /**
     * @param Module $p_module
     */
    public function __construct(Module $p_module)
    {
        $this->module = $p_module;
    }

    /**
     * Post method gets called by the framework.
     *
     * @author  Leonard Fischer <lfischer@i-doit.com>
     */
    public function post()
    {
        echo \isys_format_json::encode($this->response);
        die;
    }
}
