<?php

namespace idoit\Module\Events\Model;

use idoit\Model\Dao\Base;

/**
 * Class ReferenceOption.
 *
 * @package   idoit\Module\Events\Model
 * @author    Leonard Fischer <lfischer@i-doit.com>
 * @copyright synetics GmbH
 * @license   http://www.i-doit.com/license
 */
class ReferenceOption extends Base
{
    /**
     * @return array
     * @throws \isys_exception_database
     */
    public function getObjectTypes()
    {
        $data = [];
        $language = \isys_application::instance()->container->get('language');
        $sql = 'SELECT isys_obj_type__const AS const, isys_obj_type__title AS title 
            FROM isys_obj_type 
            WHERE isys_obj_type__status = ' . $this->convert_sql_int(C__RECORD_STATUS__NORMAL) . ';';

        $result = $this->retrieve($sql);

        while ($row = $result->get_row()) {
            $data[$row['const']] = $language->get($row['title']);
        }

        asort($data);

        return $data;
    }

    /**
     * @return array
     * @throws \isys_exception_database
     */
    public function getCategories()
    {
        $language = \isys_application::instance()->container->get('language');
        $global = $language->get('LC__CMDB__GLOBAL_CATEGORIES');
        $specific = $language->get('LC__CMDB__SPECIFIC_CATEGORIES');
        $custom = $language->get('LC__CMDB__CUSTOM_CATEGORIES');

        $data = [
            $global => [],
            $specific => [],
            $custom => []
        ];

        $sql = "SELECT isysgui_catg__const AS const, isysgui_catg__title AS title, '" . $global . "' AS type
            FROM isysgui_catg
            WHERE isysgui_catg__status = " . $this->convert_sql_int(C__RECORD_STATUS__NORMAL) . "
            
            UNION 
            
            SELECT isysgui_cats__const AS const, isysgui_cats__title AS title, '" . $specific . "' AS type
            FROM isysgui_cats
            WHERE isysgui_cats__status = " . $this->convert_sql_int(C__RECORD_STATUS__NORMAL) . "
            
            UNION 
            
            SELECT isysgui_catg_custom__const AS const, isysgui_catg_custom__title AS title, '" . $custom . "' AS type
            FROM isysgui_catg_custom
            WHERE isysgui_catg_custom__status = " . $this->convert_sql_int(C__RECORD_STATUS__NORMAL) . ';';

        $result = $this->retrieve($sql);

        while ($row = $result->get_row()) {
            $data[$row['type']][$row['const']] = $language->get($row['title']);
        }

        asort($data[$global]);
        asort($data[$specific]);
        asort($data[$custom]);

        return $data;
    }
}
