<?php

namespace idoit\Module\Events\View;

use Exception;
use idoit\Model\Dao\Base as DaoBase;
use idoit\Module\Events\Model\Subscription;
use idoit\View\Base;
use idoit\View\Renderable;
use isys_application as Application;
use isys_auth as Auth;
use isys_component_list as ComponentList;
use isys_component_template as ComponentTemplate;
use isys_component_template_navbar as ComponentNavbar;
use isys_helper_textformat as HelperTextformat;
use isys_module as ModuleBase;
use isys_module_events as ModuleEvents;

/**
 * Class EventList
 *
 * @package   idoit\Module\Events\View
 * @copyright synetics GmbH
 * @license   http://www.i-doit.com/license
 */
class EventList extends Base
{
    /**
     * @var \isys_component_template_language_manager
     */
    private $language;

    /**
     * @param ModuleBase        $p_module
     * @param ComponentTemplate $p_template
     * @param DaoBase           $p_model
     *
     * @return $this|Renderable
     */
    public function process(ModuleBase $p_module, ComponentTemplate $p_template, DaoBase $p_model)
    {
        // Set paths to templates.
        $this->paths['contentbottomcontent'] = $p_module::getPath() . 'templates/main.tpl';

        // Prepare the language manager.
        $this->language = Application::instance()->container->get('language');

        // Auth instance.
        $auth = ModuleEvents::get_auth();

        // Prepare the navbar.
        ComponentNavbar::getInstance()
            ->set_active($auth->is_allowed_to(Auth::EDIT, 'HOOKS'), C__NAVBAR_BUTTON__NEW)
            ->set_active($auth->is_allowed_to(Auth::EDIT, 'HOOKS'), C__NAVBAR_BUTTON__EDIT)
            ->set_active($auth->is_allowed_to(Auth::EDIT, 'HOOKS'), C__NAVBAR_BUTTON__DELETE);

        // Get list component.
        $l_list = new ComponentList();
        $l_list->set_row_modifier($this, 'rowModifier');
        $l_list->config([
            'title'       => 'LC__MODULE__EVENTS__DESCRIPTION',
            'source'      => 'LC__MODULE__EVENTS__SOURCE',
            'action'      => 'LC__MODULE__EVENTS__ACTION',
            'context'     => 'LC__MODULE__EVENTS__CONTEXT',
            'reference'   => 'LC__MODULE__EVENTS__REFERENCE',
            'command'     => 'LC__MODULE__EVENTS__COMMAND',
            'dateCreated' => 'LC__UNIVERSAL__DATE_CREATED',
            'objectId'    => 'LC__UNIVERSAL__FROM'
        ], \isys_core::request_url() . 'events/main/[{id}]', '[{id}]');

        $p_template
            ->assign('objectTableList', $l_list->getTempTableHtml(Subscription::instance(Application::instance()->container->get('database'))->getSubscriptions()))
            ->smarty_tom_add_rule('tom.content.bottom.buttons.*.p_bInvisible=1')
            ->smarty_tom_add_rule('tom.content.navbar.cRecStatus.p_bInvisible=1');

        return $this;
    }

    /**
     * @param array &$row
     *
     * @throws \isys_exception_locale
     */
    public function rowModifier(&$row)
    {
        try {
            $sources = array_map(function ($source) {
                return $this->language->get('LC__MODULE__EVENTS__SOURCE__' . strtoupper($source));
            }, array_filter(explode(',', $row['source'])));

            $actions = array_map(function ($action) {
                return $this->language->get('LC__MODULE__EVENTS__ACTION__' . strtoupper($action));
            }, array_filter(explode(',', $row['action'])));

            $context = array_map(function ($eventContext) {
                return $this->language->get('LC__MODULE__EVENTS__CONTEXT__' . strtoupper($eventContext));
            }, array_filter(explode(',', $row['context'])));

            if (empty($context)) {
                $context = ['LC__UNIVERSAL__ALL'];
            }

            $row['source'] = HelperTextformat::this_this_and_that($sources);
            $row['action'] = HelperTextformat::this_this_and_that($actions);
            $row['context'] = HelperTextformat::this_this_and_that($context);
            $row['reference'] = $this->language->get('LC__MODULE__EVENTS__REFERENCE__' . strtoupper($row['reference']));
            $row['dateCreated'] = Application::instance()->container->get('locales')->fmt_datetime($row['dateCreated']);
            $row['objectId'] = \isys_cmdb_dao::instance(Application::instance()->container->get('database'))->get_obj_name_by_id_as_string($row['objectId']);
        } catch (Exception $e) {
        }
    }
}
