<?php

namespace idoit\Module\Events\View;

use Exception;
use idoit\Model\Dao\Base as DaoBase;
use idoit\Module\Events\Model\Log;
use idoit\View\Base;
use idoit\View\Renderable;
use isys_application as Application;
use isys_component_list as ComponentList;
use isys_component_template as ComponentTemplate;
use isys_component_template_navbar as ComponentNavbar;
use isys_module as ModuleBase;

/**
 * Class HistoryList
 *
 * @package   idoit\Module\Events\View
 * @copyright synetics GmbH
 * @license   http://www.i-doit.com/license
 */
class HistoryList extends Base
{
    /**
     * @var \isys_component_template_language_manager
     */
    private $language;

    /**
     * @param  ModuleBase        $p_module
     * @param  ComponentTemplate $p_template
     * @param  DaoBase           $p_model
     *
     * @return $this|Renderable
     */
    public function process(ModuleBase $p_module, ComponentTemplate $p_template, DaoBase $p_model)
    {
        // Set paths to templates.
        $this->paths['contentbottomcontent'] = $p_module::getPath() . 'templates/main.tpl';

        // Prepare the language manager.
        $this->language = Application::instance()->container->get('language');

        // Hide and disable all buttons.
        ComponentNavbar::getInstance()
            ->hide_all_buttons()
            ->deactivate_all_buttons();

        // Get list component.
        $list = new ComponentList();
        $list->set_row_modifier($this, 'rowModifier');
        $list->config([
            'datetime'          => 'LC_UNIVERSAL__DATE',
            'message'           => 'LC__UNIVERSAL__MESSAGE',
            'response'          => 'LC__MODULE__EVENTS__RESPONSE',
            'status'            => 'LC__MODULE__EVENTS__STATUS_CODE',
            'subscriptionTitle' => 'LC__MODULE__EVENTS__DESCRIPTION',
            'command'           => 'LC__MODULE__EVENTS__COMMAND',
        ]);

        $p_template
            ->assign('objectTableList', $list->getTempTableHtml(Log::instance(Application::instance()->container->get('database'))->getHistory()))
            ->smarty_tom_add_rule('tom.content.bottom.buttons.*.p_bInvisible=1')
            ->smarty_tom_add_rule('tom.content.navbar.cRecStatus.p_bInvisible=1');

        return $this;
    }

    /**
     * @param array &$row
     *
     * @throws \isys_exception_locale
     */
    public function rowModifier(&$row)
    {
        try {
            $row['datetime'] = Application::instance()->container->get('locales')->fmt_datetime($row['datetime']);

            $statusIcon = 'bullet_green';
            $statusMessage = 'LC__MODULE__EVENTS__OK';

            if (!$row['status']) {
                $statusIcon = 'bullet_red';
                $statusMessage = 'LC__MODULE__EVENTS__ERROR';
            }

            $row['status'] = '<img src="' . Application::instance()->www_path . 'images/icons/silk/' . $statusIcon . '.png" /> ' .
                $this->language->get($statusMessage) . ' (' . $row['responseCode'] . ')';

            if (strlen($row['response']) > 50) {
                $row['response'] = '<button type="button" class="btn btn-small mr5 pl5 pr5" onclick="$(this).next(\'pre\').removeClassName(\'hide\');$(this).next(\'span\').remove();$(this).remove();">&raquo;</button>' .
                    '<pre class="hide">' . strip_tags($row['response']) . '</pre>' .
                    '<span class="text-monospace">' . isys_glob_str_stop($row['response'], 50) . '</span>';
            } else {
                $row['response'] = '<pre>' . strip_tags($row['response']) . '</pre>';
            }
        } catch (Exception $e) {
        }
    }
}
