<?php

namespace idoit\Module\Events\Component;

use idoit\Context\Context;

/**
 * Class EventParameter
 *
 * @package   idoit\Module\Events\Component
 * @author    Leonard Fischer <lfischer@i-doit.com>
 * @copyright synetics GmbH
 * @license   http://www.i-doit.com/license
 */
class EventParameter
{
    const SOURCE_GUI     = Context::ORIGIN_GUI;
    const SOURCE_API     = Context::ORIGIN_API;
    const SOURCE_CONSOLE = Context::ORIGIN_CONSOLE;

    const ACTION_NEW   = 'new';
    const ACTION_SAVE  = 'save';
    const ACTION_RANK  = 'rank';
    const ACTION_PURGE = 'purge';

    const CONTEXT_MANUAL   = 'manual';
    const CONTEXT_TEMPLATE = 'template';
    const CONTEXT_IMPORT   = 'import';

    const REFERENCE_OBJECT      = 'object';
    const REFERENCE_OBJECT_TYPE = 'object_type';
    const REFERENCE_CATEGORY    = 'category';

    /**
     * @return array
     */
    public static function getSources()
    {
        return [
            self::SOURCE_GUI     => 'LC__MODULE__EVENTS__SOURCE__GUI',
            self::SOURCE_API     => 'LC__MODULE__EVENTS__SOURCE__API',
            self::SOURCE_CONSOLE => 'LC__MODULE__EVENTS__SOURCE__CONSOLE'
        ];
    }

    /**
     * @return array
     */
    public static function getActions()
    {
        return [
            self::ACTION_NEW   => 'LC__MODULE__EVENTS__ACTION__NEW',
            self::ACTION_SAVE  => 'LC__MODULE__EVENTS__ACTION__SAVE',
            self::ACTION_RANK  => 'LC__MODULE__EVENTS__ACTION__RANK',
            self::ACTION_PURGE => 'LC__MODULE__EVENTS__ACTION__PURGE'
        ];
    }

    /**
     * @return array
     */
    public static function getReferences()
    {
        return [
            self::REFERENCE_OBJECT      => 'LC__MODULE__EVENTS__REFERENCE__OBJECT',
            self::REFERENCE_OBJECT_TYPE => 'LC__MODULE__EVENTS__REFERENCE__OBJECT_TYPE',
            self::REFERENCE_CATEGORY    => 'LC__MODULE__EVENTS__REFERENCE__CATEGORY'
        ];
    }

    /**
     * @return array
     */
    public static function getContexts()
    {
        return [
            self::CONTEXT_MANUAL   => 'LC__MODULE__EVENTS__CONTEXT__MANUAL',
            self::CONTEXT_TEMPLATE => 'LC__MODULE__EVENTS__CONTEXT__TEMPLATE',
            self::CONTEXT_IMPORT   => 'LC__MODULE__EVENTS__CONTEXT__IMPORT',
        ];
    }
}
