<?php

namespace idoit\Module\Events\Controller;

use idoit\Module\Events\View\HistoryList;
use isys_application as Application;
use isys_auth as Auth;
use isys_auth_events as AuthEvents;
use isys_register as Register;

/**
 * Events History controller
 *
 * @package     Modules
 * @subpackage  Events
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class History extends Main
{
    /**
     * @param Register    $p_request
     * @param Application $p_application
     *
     * @return \idoit\View\Renderable|void
     */
    public function handle(Register $p_request, Application $p_application)
    {
    }

    /**
     * @param Register    $p_request
     * @param Application $p_application
     *
     * @return HistoryList
     * @throws \isys_exception_auth
     * @throws \isys_exception_database
     */
    public function onDefault(Register $p_request, Application $p_application)
    {
        // Check for view right first.
        AuthEvents::instance()->history(Auth::VIEW);

        return new HistoryList($p_request);
    }
}
