<?php

namespace idoit\Module\Events\Handler\Output;

/**
 * event handlers
 *
 * @package     i-doit
 * @subpackage  Core
 * @author      Dennis Stücken <dstuecken@synetics.de>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class Response
{
    /**
     * @var string
     */
    public $output = '';

    /**
     * @var int
     */
    public $returnCode = 0;

    /**
     * @var bool
     */
    public $success = true;

    /**
     * Response constructor.
     *
     * @param mixed $p_output
     * @param mixed $p_code
     * @param bool  $p_success
     */
    public function __construct($p_output, $p_code, $p_success = null)
    {
        $this->returnCode = $p_code;
        $this->output = $p_output;
        if ($p_success !== null) {
            $this->success = (bool)$p_success;
        }
    }
}
