<?php

namespace idoit\Module\Events\Handler;

use Exception;
use idoit\Module\Events\Handler\Output\Response;
use isys_format_json;
use isys_tenantsettings;

/**
 * event handlers
 *
 * @package     i-doit
 * @subpackage  Core
 * @author      Dennis Stücken <dstuecken@synetics.de>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class Shell implements HandableEvent
{
    /**
     * @param  array $event
     * @param  array $args
     *
     * @return Response
     * @throws Exception
     */
    public function handleLive($event, $args)
    {
        return $this->execute($event, $args);
    }

    /**
     * @param  array $event
     * @param  array $args
     *
     * @return Response
     * @throws Exception
     */
    public function handleQueued($event, $args)
    {
        return $this->execute($event, $args);
    }

    /**
     * @param  $event
     * @param  $args
     *
     * @return Response
     * @throws Exception
     */
    private function execute($event, $args)
    {
        if (!file_exists($event['command'])) {
            throw new Exception('Command "' . $event['command'] . '" does not exist.');
        }

        if (!is_executable($event['command'])) {
            throw new Exception('Command "' . $event['command'] . '" is not executable.');
        }

        $formattedArgs = isys_format_json::encode($args);

        if (isys_tenantsettings::get('events.decodeArgs', 1)) {
            $formattedArgs = base64_encode($formattedArgs);
        }

        $l_return = [];

        exec($event['command'] . ' ' . $event['options'] . ' ' . $formattedArgs, $l_return, $l_returnCode);

        return new Response(implode("\n", $l_return), $l_returnCode, $l_returnCode == 0);
    }
}
