<?php

namespace idoit\Module\Events\Model;

use idoit\Model\Dao\Base;

/**
 * i-doit Events Model
 *
 * @package     i-doit
 * @subpackage  Core
 * @author      Dennis Stücken <dstuecken@synetics.de>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class Log extends Base
{
    const FIELDS = [
        'isys_event_log__id'                          => 'id',
        'isys_event_log__isys_event_subscription__id' => 'subscriptionId',
        'isys_event_log__message'                     => 'message',
        'isys_event_log__response'                    => 'response',
        'isys_event_log__response_code'               => 'responseCode',
        'isys_event_log__status'                      => 'status',
        'isys_event_log__datetime'                    => 'datetime',
        'isys_event_log__command'                     => 'command'
    ];

    /**
     * @param integer $eventSubsctiptionID
     * @param string  $command
     * @param string  $message
     * @param string  $response
     * @param integer $status
     * @param integer $responseCode
     *
     * @return $this
     * @throws \isys_exception_dao
     */
    public function log($eventSubsctiptionID, $message, $response, $status, $command, $responseCode = 0)
    {
        $sql = 'INSERT INTO isys_event_log SET
            isys_event_log__isys_event_subscription__id = ' . $this->convert_sql_id($eventSubsctiptionID) . ',
            isys_event_log__command = ' . $this->convert_sql_text($command) . ', 
            isys_event_log__message = ' . $this->convert_sql_text($message) . ',
            isys_event_log__response = ' . $this->convert_sql_text($response) . ',
            isys_event_log__response_code = ' . $this->convert_sql_int($responseCode) . ',
            isys_event_log__datetime = NOW(),
            isys_event_log__status = ' . $this->convert_sql_int($status) . ';';

        $this->update($sql) && $this->apply_update();

        return $this;
    }

    /**
     * @param  int $p_limit
     *
     * @return \isys_component_dao_result
     * @throws \isys_exception_database
     */
    public function getHistory($p_limit = null)
    {
        if ($p_limit === null) {
            $p_limit = 500;
        }

        $fields = array_merge(
            self::FIELDS,
            array_map(function ($field) {
                return 'subscription' . ucfirst($field);
            }, Subscription::FIELDS)
        );

        $sql = 'SELECT ' . $this->selectImplode($fields) . '
            FROM isys_event_log
            LEFT JOIN isys_event_subscription ON isys_event_log__isys_event_subscription__id = isys_event_subscription__id
            LEFT JOIN isys_event ON isys_event_subscription__isys_event__id = isys_event__id 
            ORDER BY isys_event_log__id DESC';

        if ($p_limit) {
            $sql .= ' LIMIT ' . $p_limit;
        }

        return $this->retrieve($sql . ';');
    }
}
