<table class="contentTable">
    <tr>
        <td class="key">[{isys type='f_label' name='title' ident='LC__MODULE__EVENTS__DESCRIPTION'}]</td>
        <td class="value">[{isys type='f_text' name='title'}]</td>
    </tr>
    <tr>
        <td colspan="2">
            <hr class="mt5 mb5" />
        </td>
    </tr>
    <tr>
        <td class="key">[{isys type='f_label' name='source[]' ident='LC__MODULE__EVENTS__SOURCE'}]</td>
        <td class="value">[{isys type='f_dialog' name='source[]'}]</td>
    </tr>
    <tr>
        <td class="key">[{isys type='f_label' name='action[]' ident='LC__MODULE__EVENTS__ACTION'}]</td>
        <td class="value">[{isys type='f_dialog' name='action[]'}]</td>
    </tr>
    <tr>
        <td class="key">[{isys type='f_label' name='context[]' ident='LC__MODULE__EVENTS__CONTEXT'}]</td>
        <td class="value pl20">
            [{if isys_glob_is_edit_mode()}]
            <div class="input-group input-size-small">
                [{isys type='f_dialog' name='context[]'}]
                <div class="input-group-addon">
                    <img src="[{$dir_images}]axialis/basic/button-help.svg" title="[{isys type="lang" ident="LC__MODULE__EVENTS__CONTEXT_DESCRIPTION" p_bHtmlEncode=false}]" data-tooltip="1" />
                </div>
            </div>
            [{else}]
                [{isys type='f_dialog' name='context[]'}]
            [{/if}]
        </td>
    </tr>
    <tr>
        <td class="key">[{isys type='f_label' name='reference' ident='LC__MODULE__EVENTS__REFERENCE'}]</td>
        <td class="value">[{isys type='f_dialog' name='reference'}]</td>
    </tr>
    <tr>
        <td class="key">[{isys type='f_label' name='reference_option' ident='LC__MODULE__EVENTS__REFERENCE_OPTION'}]</td>
        <td class="value">[{isys type='f_dialog' id="reference_option" name='reference_option[]'}]</td>
    </tr>
    <tr>
        <td colspan="2">
            <hr class="mt5 mb5" />
        </td>
    </tr>
    <tr>
        <td class="key">[{isys type='f_label' name='command' ident='LC__MODULE__EVENTS__COMMAND'}]</td>
        <td class="value">[{isys type='f_text' name='command' p_strPlaceholder='/path/to/bash/script.sh'}]</td>
    </tr>
    <tr>
        <td class="key vat">[{isys type='f_label' name='parameters' ident='LC__MODULE__EVENTS__ADDITIONAL_PARAMETERS'}]</td>
        <td class="value">
            [{isys type='f_text' name='parameters'}]
            <br class="cb" />
            <p class="m5 ml20 box-blue p5">
                <img src="[{$dir_images}]axialis/basic/button-info.svg" class="vam mr5" />
                <span class="vam">[{isys type="lang" ident="LC__MODULE__EVENTS__ADDITIONAL_PARAMETERS__HELP" p_bHtmlEncode=false}]</span>
            </p>
        </td>
    </tr>

</table>

<input type="hidden" name="eventSubscriptionID" value="[{$eventSubscriptionID}]" />

<script type="text/javascript">
    (function () {
        "use strict";

        var $referenceSelect       = $('reference'),
            $referenceOptionSelect = $('reference_option');

        if ($referenceSelect && $referenceOptionSelect) {
            $referenceSelect.on('change', function () {
                var previousValue = $referenceOptionSelect.getValue();

                $referenceOptionSelect.disable();

                if ($referenceSelect.getValue() === '[{idoit\Module\Events\Component\EventParameter::REFERENCE_OBJECT_TYPE}]') {
                    $referenceOptionSelect.up('td').addClassName('hide');
                    $referenceOptionSelect.fire('chosen:updated');

                    return;
                }

                new Ajax.Request('[{$baseUrl}]events/ajax/loadReferenceOptions', {
                    method:     'post',
                    parameters: {
                        reference: $referenceSelect.getValue()
                    },
                    onComplete: function (xhr) {
                        var json = xhr.responseJSON, $optgroup, i, j;

                        $referenceOptionSelect.up('td').removeClassName('hide');
                        $referenceOptionSelect.update();

                        if (json.success) {
                            $referenceOptionSelect.enable();

                            for (i in json.data) {
                                if (!json.data.hasOwnProperty(i)) {
                                    continue;
                                }

                                if (Object.isString(json.data[i])) {
                                    $referenceOptionSelect.insert(new Element('option', {value: i}).update(json.data[i]));
                                } else {
                                    $optgroup = new Element('optgroup', {label: i});

                                    for (j in json.data[i]) {
                                        if (!json.data[i].hasOwnProperty(j)) {
                                            continue;
                                        }

                                        $optgroup.insert(new Element('option', {value: j}).update(json.data[i][j]));
                                    }

                                    $referenceOptionSelect.insert($optgroup)
                                }
                            }
                        } else {
                            idoit.Notify.error(json.message || xhr.responseText, {sticky: true});
                        }

                        $referenceOptionSelect.setValue(previousValue);
                        $referenceOptionSelect.fire('chosen:updated');
                    }
                });
            });

            $referenceSelect.simulate('change');
        }
    }());
</script>
